/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpAbs
extends IntExpImpl {
    private IntExp _exp;
    private Observer _observer;
    private IntVar _abs;

    static int abs_max(int min, int max) {
        if (min >= 0) {
            return max;
        }
        if (max < 0) {
            return -min;
        }
        return Math.max(-min, max);
    }

    static int abs_min(int min, int max) {
        if (min >= 0) {
            return min;
        }
        if (max >= 0) {
            return 0;
        }
        return -max;
    }

    public IntExpAbs(IntExp exp) {
        super(exp.constrainer());
        this._exp = exp;
        this._observer = new ExpAbsObserver();
        this._exp.attachObserver(this._observer);
        if (this.constrainer().showInternalNames()) {
            this._name = "|" + exp.name() + "|";
        }
        int trace = 0;
        int min = this._exp.min();
        int max = this._exp.max();
        this._abs = this.constrainer().addIntVarTraceInternal(IntExpAbs.abs_min(min, max), IntExpAbs.abs_max(min, max), this._name, 0, trace);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._abs.attachObserver(observer);
    }

    @Override
    public boolean contains(int value) {
        return this._abs.contains(value);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._abs.detachObserver(observer);
    }

    @Override
    public int max() {
        return this._abs.max();
    }

    @Override
    public int min() {
        return this._abs.min();
    }

    @Override
    public void onMaskChange() {
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._abs.reattachObserver(observer);
    }

    @Override
    public void removeValue(int value) throws Failure {
        if (value >= 0) {
            this._abs.removeValue(value);
            this._exp.removeValue(value);
            this._exp.removeValue(-value);
        }
    }

    @Override
    public void setMax(int max) throws Failure {
        this._abs.setMax(max);
        this._exp.setMax(max);
        this._exp.setMin(-max);
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min <= 0) {
            return;
        }
        this._abs.setMin(min);
        int removeMax = min - 1;
        this._exp.removeRange(-removeMax, removeMax);
    }

    @Override
    public void setValue(int value) throws Failure {
        this._abs.setValue(value);
        this.setMax(value);
        this.setMin(value);
    }

    class ExpAbsObserver
    extends Observer {
        ExpAbsObserver() {
        }

        @Override
        public Object master() {
            return IntExpAbs.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpAbsObserver: " + IntExpAbs.this._exp;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            int min = e.min();
            int max = e.max();
            IntExpAbs.this._abs.setMin(IntExpAbs.abs_min(min, max));
            IntExpAbs.this._abs.setMax(IntExpAbs.abs_max(min, max));
        }
    }
}

