/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntExpMultiplyPositive
extends IntExpImpl {
    private IntExp _exp;
    private int _value;
    private ExpressionObserver _observer;

    public IntExpMultiplyPositive(IntExp exp, int value) {
        super(exp.constrainer());
        if (value <= 0) {
            this.abort("negative value in IntExpMultiplyPositive");
        }
        this._exp = exp;
        this._value = value;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "*" + value + ")";
        }
        this._observer = new ExpMultiplyPositiveObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public boolean bound() {
        return this._exp.bound();
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, factor * (double)this._value);
    }

    @Override
    public boolean contains(int value) {
        if (value % this._value != 0) {
            return false;
        }
        return this._exp.contains(value / this._value);
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear();
    }

    @Override
    public int max() {
        return this._exp.max() * this._value;
    }

    @Override
    public int min() {
        return this._exp.min() * this._value;
    }

    @Override
    public IntExp mul(int value) {
        return this._exp.mul(this._value * value);
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void removeValue(int value) throws Failure {
        if (value % this._value != 0) {
            return;
        }
        this._exp.removeValue(value / this._value);
    }

    @Override
    public void setMax(int max) throws Failure {
        int Pmax = max;
        int v = this._value;
        int q = Pmax / v;
        int delta = Pmax - q * v;
        int Max = delta >= 0 ? q : q - 1;
        this._exp.setMax(Max);
    }

    @Override
    public void setMin(int min) throws Failure {
        int v;
        int q;
        int Pmin;
        int delta;
        if (min < this.min()) {
            return;
        }
        if (min > this.max()) {
            this.constrainer().fail("Mul Positive Set Min");
        }
        int Min = (delta = (Pmin = min) - (q = Pmin / (v = this._value)) * v) > 0 ? q + 1 : q;
        this._exp.setMin(Min);
    }

    @Override
    public void setValue(int value) throws Failure {
        if (value % this._value != 0) {
            this.constrainer().fail("invalid setValue in IntExpMultiplyPositiveImpl");
        }
        this._exp.setValue(value / this._value);
    }

    @Override
    public int size() {
        return this._exp.size();
    }

    @Override
    public int value() throws Failure {
        if (!this._exp.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound expression " + this);
        }
        return this._exp.value() * this._value;
    }

    static class IntEventMulPositiveValue
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new IntEventMulPositiveValue();
            }
        };
        int _value;
        IntEvent _event;

        IntEventMulPositiveValue() {
        }

        static IntEventMulPositiveValue getEvent(IntEvent event, int value) {
            IntEventMulPositiveValue ev = (IntEventMulPositiveValue)_factory.getElement();
            ev.init(event, value);
            return ev;
        }

        public void init(IntEvent e, int value) {
            this._event = e;
            this._value = value;
        }

        @Override
        public int max() {
            return this._event.max() * this._value;
        }

        @Override
        public int min() {
            return this._event.min() * this._value;
        }

        @Override
        public String name() {
            return "Event MulValue";
        }

        @Override
        public int numberOfRemoves() {
            return this._event.numberOfRemoves();
        }

        @Override
        public int oldmax() {
            return this._event.oldmax() * this._value;
        }

        @Override
        public int oldmin() {
            return this._event.oldmin() * this._value;
        }

        @Override
        public int removed(int i) {
            return this._event.removed(i) * this._value;
        }

        @Override
        public int type() {
            return this._event.type();
        }
    }

    class ExpMultiplyPositiveObserver
    extends ExpressionObserver {
        ExpMultiplyPositiveObserver() {
        }

        @Override
        public Object master() {
            return IntExpMultiplyPositive.this;
        }

        @Override
        public String toString() {
            return "ExpMultiplyPositiveObserver: " + IntExpMultiplyPositive.this._exp + "*" + IntExpMultiplyPositive.this._value;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            IntEventMulPositiveValue ev = IntEventMulPositiveValue.getEvent(e, IntExpMultiplyPositive.this._value);
            IntExpMultiplyPositive.this.notifyObservers(ev);
        }
    }
}

