/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpPowIntValue
extends IntExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private IntExp _exp;
    private int _value;
    private IntVar _result;
    private ExpressionObserver _observer;

    static int calc_max(int min, int max, int value) {
        if (value % 2 == 0) {
            return Math.max((int)Math.pow(min, value), (int)Math.pow(max, value));
        }
        return (int)Math.pow(max, value);
    }

    static int calc_min(int min, int max, int value) {
        if (value % 2 == 0) {
            if (min >= 0) {
                return (int)Math.pow(min, value);
            }
            if (max <= 0) {
                return (int)Math.pow(max, value);
            }
            return 0;
        }
        return (int)Math.pow(min, value);
    }

    public IntExpPowIntValue(IntExp exp, int value) {
        super(exp.constrainer());
        this._exp = exp;
        this._value = value;
        if (this.constrainer().showInternalNames()) {
            this._name = "IlcPower(" + exp.name() + "," + value + ")";
        }
        this._observer = new IntExpPowIntValueObserver();
        this._exp.attachObserver(this._observer);
        int min = this._exp.min();
        int max = this._exp.max();
        int trace = 0;
        int domain = 0;
        this._result = this.constrainer().addIntVarTraceInternal(IntExpPowIntValue.calc_min(min, max, this._value), IntExpPowIntValue.calc_max(min, max, this._value), "pow", domain, trace);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._result.attachObserver(observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this._value != 0 && this._value != 1) {
            throw new NonLinearExpression(this);
        }
        if (this._value == 0) {
            return 1.0;
        }
        return this._exp.calcCoeffs(map, factor);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._result.detachObserver(observer);
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear() && (this._value == 1 || this._value == 0);
    }

    @Override
    public int max() {
        return this._result.max();
    }

    @Override
    public int min() {
        return this._result.min();
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._result.reattachObserver(observer);
    }

    @Override
    public void setMax(int max) throws Failure {
        if (this._value % 2 == 0 && max < 0) {
            this.constrainer().fail("pow(exp,value).setMax(): max < 0 for even value");
        }
    }

    @Override
    public void setMin(int min) throws Failure {
        if (this._value % 2 == 0 && min <= 0) {
            return;
        }
    }

    @Override
    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public String toString() {
        return "pow(" + this._exp + "," + this._value + ")" + this.domainToString();
    }

    class IntExpPowIntValueObserver
    extends ExpressionObserver {
        IntExpPowIntValueObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return IntExpPowIntValue.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        @Override
        public String toString() {
            return "IntExpPowIntValueObserver: pow(" + IntExpPowIntValue.this._exp + "," + IntExpPowIntValue.this._value + ")";
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            int min = IntExpPowIntValue.this._exp.min();
            int max = IntExpPowIntValue.this._exp.max();
            IntExpPowIntValue.this._result.setMin(IntExpPowIntValue.calc_min(min, max, IntExpPowIntValue.this._value));
            IntExpPowIntValue.this._result.setMax(IntExpPowIntValue.calc_max(min, max, IntExpPowIntValue.this._value));
        }
    }
}

