/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.scheduler.AlternativeResourceConstraint;
import org.openl.ie.scheduler.AlternativeResourceSet;
import org.openl.ie.scheduler.Job;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.Schedule;

public class JobInterval
implements Job {
    private Constrainer _constrainer;
    private Schedule _schedule;
    private IntVar _start;
    private IntVar _end;
    private int _duration;
    private int _s_min;
    private int _e_max;
    private String _name;

    public JobInterval(Schedule sch, int duration) throws Failure {
        this._duration = duration;
        this._schedule = sch;
        this._constrainer = this._schedule.constrainer();
        this._start = this._constrainer.addIntVar(this._schedule.start(), this._schedule.end());
        this._end = this._constrainer.addIntVar(this._schedule.start(), this._schedule.end());
        this._constrainer.postConstraint(this._end.eq(this._start.add(this._duration)));
        this.saveAssignmentInfo();
    }

    @Override
    public boolean bound() {
        return this._start.bound();
    }

    @Override
    public Constrainer constrainer() {
        return this._constrainer;
    }

    @Override
    public int duration() {
        return this._duration;
    }

    @Override
    public int endMax() {
        return this._end.max();
    }

    @Override
    public int endMaxA() {
        return this._e_max;
    }

    @Override
    public IntBoolExp endsAfterEnd(Job job) {
        return job.getEndVariable().le(this._end);
    }

    @Override
    public IntBoolExp endsAfterStart(Job job) {
        return job.getStartVariable().le(this._end);
    }

    @Override
    public String getAssignment() {
        return this._schedule.getAssignments(this);
    }

    @Override
    public IntVar getEndVariable() {
        return this._end;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public IntVar getStartVariable() {
        return this._start;
    }

    @Override
    public AlternativeResourceConstraint requires(AlternativeResourceSet res, int capacity) {
        return new AlternativeResourceConstraint((Job)this, res, capacity);
    }

    @Override
    public AlternativeResourceConstraint requires(AlternativeResourceSet res, IntVar capacity) {
        return new AlternativeResourceConstraint((Job)this, res, capacity);
    }

    @Override
    public AlternativeResourceConstraint requires(Resource res, int capacity) {
        AlternativeResourceSet set = new AlternativeResourceSet();
        set.add(res);
        return this.requires(set, capacity);
    }

    @Override
    public AlternativeResourceConstraint requires(Resource res, IntVar capacity) {
        AlternativeResourceSet set = new AlternativeResourceSet();
        set.add(res);
        return this.requires(set, capacity);
    }

    @Override
    public void saveAssignmentInfo() {
        this._s_min = this._start.min();
        this._e_max = this._end.max();
    }

    @Override
    public Schedule schedule() {
        return this._schedule;
    }

    @Override
    public void setName(String name) {
        this._name = name;
        this._start.name(this._name + ".start");
        this._end.name(this._name + ".end");
    }

    @Override
    public int startMin() {
        return this._start.min();
    }

    @Override
    public int startMinA() {
        return this._s_min;
    }

    @Override
    public IntBoolExp startsAfterEnd(Job job) {
        return job.getEndVariable().le(this._start);
    }

    @Override
    public IntBoolExp startsAfterStart(Job job) {
        return job.getStartVariable().le(this._start);
    }

    @Override
    public IntBoolExp startsAtStart(Job job) {
        return job.getStartVariable().eq(this._start);
    }

    @Override
    public String toString() {
        return this.getName() + this.value();
    }

    @Override
    public String value() {
        try {
            String assignments = this._schedule.getAssignments(this);
            return "[" + this.getStartVariable().value() + " --" + this._duration + "--> " + this.getEndVariable().value() + ")" + (assignments.equalsIgnoreCase("") ? "" : " => " + assignments);
        }
        catch (Failure f) {
            return "[" + this.getStartVariable().domainToString() + " --" + this._duration + "--> " + this.getEndVariable().domainToString() + ")";
        }
    }
}

