/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

public class VarType {
    public static final int LPX_FR = VarType.native_LPX_FR();
    public static final int LPX_LO = VarType.native_LPX_LO();
    public static final int LPX_UP = VarType.native_LPX_UP();
    public static final int LPX_DB = VarType.native_LPX_DB();
    public static final int LPX_FX = VarType.native_LPX_FX();
    private double _lb = -1.7976931348623157E308;
    private double _ub = Double.MAX_VALUE;
    private int _type = LPX_FR;

    private static native int native_LPX_DB();

    private static native int native_LPX_FR();

    private static native int native_LPX_FX();

    private static native int native_LPX_LO();

    private static native int native_LPX_UP();

    public VarType() {
        this.setType(LPX_FR);
    }

    public VarType(double lb, double ub) {
        this(LPX_DB, lb, ub);
    }

    public VarType(int type, double lb, double ub) {
        this.setType(type);
        if (lb > ub && (type == LPX_FR || type == LPX_DB)) {
            throw new IllegalArgumentException("the upper bound must not be less then the lower bound");
        }
        this._lb = lb;
        this._ub = ub;
    }

    public double getLb() {
        if (this._type == LPX_FR || this._type == LPX_UP) {
            return -1.7976931348623157E308;
        }
        return this._lb;
    }

    public int getType() {
        return this._type;
    }

    public double getUb() {
        if (this._type == LPX_FR || this._type == LPX_LO) {
            return Double.MAX_VALUE;
        }
        return this._ub;
    }

    public void setBounds(double lb, double ub) {
        if (lb > ub && this._type == LPX_DB) {
            throw new IllegalArgumentException("the upper bound must not be less then the lower bound");
        }
        this._lb = lb;
        this._ub = ub;
    }

    public void setType(int type) {
        if (type != LPX_FR && type != LPX_LO && type != LPX_UP && type != LPX_DB && type != LPX_FX) {
            throw new IllegalArgumentException("unsupported variable's bounds type");
        }
        this._type = type;
    }

    public String toString() {
        String vartype = "";
        String sub = "";
        String slb = "";
        if (this._type == LPX_FR) {
            vartype = vartype + "Free";
        }
        if (this._type == LPX_LO) {
            vartype = vartype + "BoundedBelow";
            slb = " lb=" + this._lb;
        }
        if (this._type == LPX_UP) {
            vartype = vartype + "BoundedAbove";
            sub = " ub=" + this._ub;
        }
        if (this._type == LPX_DB) {
            vartype = vartype + "Bounded";
            slb = " lb=" + this._lb;
            sub = " ub=" + this._ub;
        }
        if (this._type == LPX_FX) {
            vartype = vartype + "Fixed";
            slb = " lb=" + this._lb;
            sub = " ub=" + this._lb;
        }
        return "[Type=" + vartype + sub + slb + "]";
    }
}

