/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.ccc;

import org.openl.ie.ccc.CccCore;
import org.openl.ie.ccc.CccGoal;
import org.openl.ie.ccc.CccVariable;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.GoalFloatMinimize;
import org.openl.util.Log;

public class CccFloat
extends CccVariable {
    private double _min;
    private double _max;
    private FloatExp _constrainer_float;
    private String _value;
    private CccGoal _goal_minimize;
    private CccGoal _goal_maximize;

    public CccFloat(CccCore core, double min, double max, String name) {
        super(core, 2, name);
        this._min = min;
        this._max = max;
        this._value = "[" + min + ";" + max + "]";
        try {
            this._constrainer_float = core.constrainer().addFloatVar(min, max, name);
        }
        catch (Exception e) {
            Log.error((Object)("Invalid min/max: " + e));
        }
    }

    public CccFloat(CccCore core, FloatExp i) {
        this(core, i, i.name());
    }

    public CccFloat(CccCore core, FloatExp i, String newname) {
        super(core, 2, newname);
        this._constrainer_float = i;
        this.fetchConstrainerState();
    }

    public FloatExp constrainerFloat() {
        return this._constrainer_float;
    }

    public void constrainerFloat(FloatExp var) {
        this._constrainer_float = var;
    }

    @Override
    public String debugInfo() {
        return "observers=" + this._constrainer_float.observers().size();
    }

    @Override
    public void fetchConstrainerState() {
        this.min(this.round(this._constrainer_float.min()));
        this.max(this.round(this._constrainer_float.max()));
        this.bound(this._constrainer_float.bound());
        if (this.bound()) {
            this.status(1);
            this.value("[" + this.min() + "]");
        } else {
            this.status(0);
            this.value("[" + this.round(this._constrainer_float.min()) + ";" + this.round(this._constrainer_float.max()) + "]");
        }
    }

    @Override
    public CccGoal getMaximizeGoal() {
        if (this._goal_maximize == null) {
            this._goal_maximize = new CccGoal(this.core(), "MAXIMIZE");
            this._goal_maximize.executable(new GoalFloatMinimize(this.core().getGoalSolution().executable(), this._constrainer_float.neg()));
        }
        return this._goal_maximize;
    }

    @Override
    public CccGoal getMinimizeGoal() {
        if (this._goal_minimize == null) {
            this._goal_minimize = new CccGoal(this.core(), "MINIMIZE");
            this._goal_minimize.executable(new GoalFloatMinimize(this.core().getGoalSolution().executable(), this._constrainer_float));
        }
        return this._goal_minimize;
    }

    public double max() {
        return this._max;
    }

    public void max(double m) {
        this._max = m;
    }

    public double min() {
        return this._min;
    }

    public void min(double m) {
        this._min = m;
    }

    double round(double x) {
        return (double)((int)((x + 0.005) * 100.0)) / 100.0;
    }

    @Override
    public String toString() {
        return this.name() + this.value();
    }

    @Override
    public String value() {
        return this._value;
    }

    public void value(String v) {
        this._value = v;
    }
}

