/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntVar;

public class Session {
    Constrainer _c = null;
    boolean restored = false;
    IntVar[] _intVars = null;
    FloatVar[] _floatVars = null;
    Goal _mainGoal = null;
    ChoicePointLabel _label = null;

    public Session(Constrainer c, IntVar[] intVarsOfInterest, FloatVar[] floatVarsOfInterest, Goal mainGoal) {
        if (c == null) {
            throw new IllegalArgumentException("Can't create session object: reference to Constrainer object equals \"null\"");
        }
        this._c = c;
        this._intVars = intVarsOfInterest;
        this._floatVars = floatVarsOfInterest;
        this._mainGoal = mainGoal;
    }

    public Session(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.restore(in);
        this.restored = true;
    }

    public boolean execute(boolean restore_flag) {
        if (!this.restored) {
            return this._c.execute(this._mainGoal, restore_flag);
        }
        if (this._mainGoal != null) {
            return this._mainGoal.toContinue(this._label, restore_flag);
        }
        return this._c.toContinue(this._label, restore_flag);
    }

    public Constrainer getConstrainer() {
        return this._c;
    }

    public FloatVar[] getFloatVarsOfInterest() {
        return this._floatVars;
    }

    public IntVar[] getIntVarsOfInterest() {
        return this._intVars;
    }

    public Goal getMainGoal() {
        return this._mainGoal;
    }

    public void restore(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._c = (Constrainer)in.readObject();
        this._c.out(System.out);
        this._mainGoal = (Goal)in.readObject();
        int[] indices = (int[])in.readObject();
        this._intVars = this._c.getIntVars(indices);
        indices = (int[])in.readObject();
        this._floatVars = this._c.getFloatVars(indices);
        this._label = (ChoicePointLabel)in.readObject();
    }

    public void setChoicePointLabel(ChoicePointLabel label) {
        this._label = label;
    }

    public void setConstrainer(Constrainer C) {
        this._c = C;
    }

    public void setFloatVarsOfInterest(FloatVar[] array) {
        this._floatVars = array;
    }

    public void setIntVarsOfInterest(IntVar[] array) {
        this._intVars = array;
    }

    public void setMainGoal(Goal goal) {
        this._mainGoal = goal;
    }

    public void store(ObjectOutputStream sout) throws IOException {
        if (this._label == null) {
            this._label = this._c.currentChoicePointLabel();
        }
        sout.writeObject(this._c);
        sout.writeObject(this._mainGoal);
        sout.writeObject(this._c.findAppropriate(this._intVars));
        sout.writeObject(this._c.findAppropriate(this._floatVars));
        sout.writeObject(this._label);
    }
}

