/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpInverse
extends FloatExpImpl {
    private static final int[] event_map = new int[]{2, 4, 4, 2, 1, 1, 8, 8};
    private FloatExp _exp;
    private ExpressionObserver _observer;

    public FloatExpInverse(FloatExp exp) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._observer = new FloatExpInverseObserver();
        this._exp.attachObserver(this._observer);
    }

    public FloatExp inverse() {
        return this._exp;
    }

    @Override
    public double max() {
        return FloatCalc.inverseMax(this._exp.min(), this._exp.max());
    }

    @Override
    public double min() {
        return FloatCalc.inverseMin(this._exp.min(), this._exp.max());
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void setMax(double max) throws Failure {
        double min = this.min();
        double expMin = FloatCalc.inverseMin(min, max);
        double expMax = FloatCalc.inverseMax(min, max);
        this._exp.setMin(expMin);
        this._exp.setMax(expMax);
    }

    @Override
    public void setMin(double min) throws Failure {
        double max = this.max();
        double expMin = FloatCalc.inverseMin(min, max);
        double expMax = FloatCalc.inverseMax(min, max);
        this._exp.setMin(expMin);
        this._exp.setMax(expMax);
    }

    @Override
    public void setValue(double value) throws Failure {
        double expMin = FloatCalc.inverseMin(value);
        double expMax = FloatCalc.inverseMax(value);
        this._exp.setMin(expMin);
        this._exp.setMax(expMax);
    }

    @Override
    public String toString() {
        return "1/" + this._exp + this.domainToString();
    }

    class FloatExpInverseObserver
    extends ExpressionObserver {
        FloatExpInverseObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return FloatExpInverse.this;
        }

        @Override
        public String toString() {
            return "FloatExpInverseObserver: " + FloatExpInverse.this._exp;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventInverse ev = FloatEventInverse.getEvent(e, FloatExpInverse.this);
            FloatExpInverse.this.notifyObservers(ev);
        }
    }

    static class FloatEventInverse
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new FloatEventInverse();
            }
        };
        FloatEvent _event;
        double _min;
        double _max;
        double _oldmin;
        double _oldmax;
        int _type;

        FloatEventInverse() {
        }

        static FloatEventInverse getEvent(FloatEvent event, FloatExpInverse exp) {
            FloatEventInverse ev = (FloatEventInverse)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        public void init(FloatEvent e, FloatExpInverse exp) {
            int type;
            this.exp(exp);
            this._min = FloatCalc.inverseMin(e.min(), e.max());
            this._max = FloatCalc.inverseMax(e.min(), e.max());
            this._oldmin = FloatCalc.inverseMin(e.oldmin(), e.oldmax());
            this._oldmax = FloatCalc.inverseMax(e.oldmin(), e.oldmax());
            FloatCalc.doAssert(this._min >= this._oldmin, "_min>=_oldmin");
            FloatCalc.doAssert(this._max <= this._oldmax, "_max>=_oldmax");
            this._event = e;
            this._type = type = e.type();
            this._type &= 6;
            if (this._max < this._oldmax) {
                this._type |= 4;
            }
            if (this._min > this._oldmin) {
                this._type |= 2;
            }
        }

        @Override
        public double max() {
            return this._max;
        }

        @Override
        public double min() {
            return this._min;
        }

        @Override
        public String name() {
            return "FloatEventInverse";
        }

        @Override
        public double oldmax() {
            return this._oldmax;
        }

        @Override
        public double oldmin() {
            return this._oldmin;
        }

        @Override
        public int type() {
            return this._type;
        }
    }
}

