/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpMulExpPP
extends FloatExpImpl {
    private static final int[] event_map = new int[]{2, 2, 4, 4};
    private FloatExp _exp1;
    private FloatExp _exp2;
    private ExpressionObserver _observer;
    private FloatVar _product;

    public FloatExpMulExpPP(FloatExp exp1, FloatExp exp2) {
        super(exp1.constrainer(), "");
        this._exp1 = exp1;
        this._exp2 = exp2;
        int trace = 0;
        this._product = this.constrainer().addFloatVarTraceInternal(this.calc_min(), this.calc_max(), "mul", trace);
        this._observer = new FloatExpMulExpPPObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._product.attachObserver(observer);
    }

    double calc_max() {
        return this._exp1.max() * this._exp2.max();
    }

    double calc_min() {
        return this._exp1.min() * this._exp2.min();
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this._exp1.bound()) {
            return this._exp2.calcCoeffs(map, factor * this._exp1.max());
        }
        if (this._exp2.bound()) {
            return this._exp1.calcCoeffs(map, factor * this._exp2.max());
        }
        throw new NonLinearExpression(this);
    }

    private boolean checkMe(String s) {
        if (this.calc_max() != this._product.max() || this.calc_min() != this._product.min()) {
            System.out.println(s + "[" + this.calc_min() + ".." + this.calc_max() + "]!=" + this);
            return false;
        }
        return true;
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._product.detachObserver(observer);
    }

    @Override
    public boolean isLinear() {
        if (!this._exp1.bound() && !this._exp2.bound()) {
            return false;
        }
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    @Override
    public double max() {
        return this._product.max();
    }

    @Override
    public double min() {
        return this._product.min();
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp1);
        this._observer.publish(this.publisherMask(), this._exp2);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._product.reattachObserver(observer);
    }

    @Override
    public void setMax(double max) throws Failure {
        double Max;
        double v;
        if (max >= this.max()) {
            return;
        }
        if (max < this.min()) {
            this.constrainer().fail("FloatExpMulExpPP.setMax(): max < min()");
        }
        if ((v = this._exp2.min()) > 0.0) {
            Max = max / v;
            this._exp1.setMax(Max);
        }
        if ((v = this._exp1.min()) > 0.0) {
            Max = max / v;
            this._exp2.setMax(Max);
        }
    }

    @Override
    public void setMin(double min) throws Failure {
        double Min;
        double v;
        if (min <= this.min()) {
            return;
        }
        if (min > this.max()) {
            this.constrainer().fail("FloatExpMulExpPP.setMin(): min > max()");
        }
        if ((v = this._exp2.max()) > 0.0) {
            Min = min / v;
            this._exp1.setMin(Min);
        }
        if ((v = this._exp1.max()) > 0.0) {
            Min = min / v;
            this._exp2.setMin(Min);
        }
    }

    @Override
    public void setValue(double value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public String toString() {
        return this._exp1 + " x " + this._exp2;
    }

    class FloatExpMulExpPPObserver
    extends ExpressionObserver {
        FloatExpMulExpPPObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return FloatExpMulExpPP.this;
        }

        @Override
        public String toString() {
            return "FloatExpMulExpPPObserver: " + FloatExpMulExpPP.this._exp1 + " x " + FloatExpMulExpPP.this._exp2;
        }

        @Override
        public void update(Subject subject, EventOfInterest event) throws Failure {
            FloatExpMulExpPP.this._product.setMax(FloatExpMulExpPP.this.calc_max());
            FloatExpMulExpPP.this._product.setMin(FloatExpMulExpPP.this.calc_min());
        }
    }
}

