/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;
import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.impl.UndoStack;
import org.openl.ie.tools.FastStack;

public final class GoalStack
implements Serializable {
    private FastStack _exeStack;
    private FastStack _choicePointStack;
    private int _undoStackSize;
    private UndoStack _undoStack;

    public GoalStack(FastStack initialGoals, UndoStack undoStack) {
        this.init((FastStack)initialGoals.clone(), undoStack);
    }

    public GoalStack(Goal mainGoal, UndoStack undoStack) {
        FastStack initialGoals = new FastStack();
        initialGoals.push(mainGoal);
        this.init(initialGoals, undoStack);
    }

    public GoalStack(UndoStack undoStack) {
        this.init(new FastStack(), undoStack);
    }

    public final boolean backtrack(ChoicePointLabel label) {
        ChoicePoint cp = this.backtrackStack(label);
        if (cp != null) {
            this._undoStack.backtrack(cp.undoStackSize());
            this.pushGoal(cp.goal());
            return true;
        }
        this._undoStack.backtrack(this.undoStackSize());
        return false;
    }

    public final ChoicePoint backtrackStack(ChoicePointLabel label) {
        while (!this._choicePointStack.empty()) {
            ChoicePoint cp = (ChoicePoint)this._choicePointStack.pop();
            if (label != null && !label.equals(cp.label())) continue;
            this._exeStack = cp.exeStack();
            return cp;
        }
        this._exeStack.clear();
        return null;
    }

    public final ChoicePoint currentChoicePoint() {
        if (this._choicePointStack.empty()) {
            throw new RuntimeException("No current choice point");
        }
        return (ChoicePoint)this._choicePointStack.peek();
    }

    public final boolean empty() {
        return this._exeStack.empty();
    }

    final void init(FastStack initialGoals, UndoStack undoStack) {
        this._exeStack = initialGoals;
        this._choicePointStack = new FastStack();
        this._undoStack = undoStack;
        this._undoStackSize = undoStack.size();
    }

    public final Goal popGoal() {
        return (Goal)this._exeStack.pop();
    }

    public final void pushGoal(Goal goal) {
        this._exeStack.push(goal);
    }

    public final void setChoicePoint(Goal g1, Goal g2, ChoicePointLabel label) {
        ChoicePoint cp = new ChoicePoint(g2, label, this._exeStack, this._undoStack.size());
        this._choicePointStack.push(cp);
        this.pushGoal(g1);
    }

    public String toString() {
        return "GoalStack: \n\tExecutionStack: " + this._exeStack + "\n\tChiocePointStack: " + this._choicePointStack;
    }

    public final int undoStackSize() {
        return this._undoStackSize;
    }

    public static class ChoicePoint
    implements Serializable {
        Goal _goal;
        ChoicePointLabel _label;
        FastStack _exeStack;
        int _undoStackSize;

        public ChoicePoint(Goal goal, ChoicePointLabel label, FastStack exeStack, int undoStackSize) {
            this._goal = goal;
            this._label = label;
            this._exeStack = (FastStack)exeStack.clone();
            this._undoStackSize = undoStackSize;
        }

        public final FastStack exeStack() {
            return this._exeStack;
        }

        public final Goal goal() {
            return this._goal;
        }

        public final ChoicePointLabel label() {
            return this._label;
        }

        public final int undoStackSize() {
            return this._undoStackSize;
        }
    }
}

