/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

public final class IntBoolExpEqExp
extends IntBoolExpForSubject {
    private IntExp _exp1;
    private IntExp _exp2;
    private int _offset;
    private Observer _observer;

    public IntBoolExpEqExp(IntExp exp1, IntExp exp2) {
        this(exp1, exp2, 0);
    }

    public IntBoolExpEqExp(IntExp exp1, IntExp exp2, int offset) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._offset = offset;
        if (this.constrainer().showInternalNames()) {
            this._name = offset == 0 ? "(" + exp1.name() + "==" + exp2.name() + ")" : (offset > 0 ? "(" + exp1.name() + "==" + exp2.name() + "+" + offset + ")" : "(" + exp1.name() + "==" + exp2.name() + offset + ")");
        }
        this.setDomainMinMaxSafe();
        this._observer = new ObserverMinMax();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp2.sub(this._exp1).sub(this._offset).calcCoeffs(map, factor);
    }

    @Override
    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    @Override
    protected boolean isSubjectFalse() {
        return this._exp1.min() > this._exp2.max() + this._offset || this._exp1.max() < this._exp2.min() + this._offset;
    }

    @Override
    protected boolean isSubjectTrue() {
        return this._exp1.min() == this._exp2.max() + this._offset && this._exp1.max() == this._exp2.min() + this._offset;
    }

    @Override
    protected void setSubjectFalse() throws Failure {
        if (this._exp2.bound()) {
            this._exp1.removeValue(this._exp2.value() + this._offset);
        }
        if (this._exp1.bound()) {
            this._exp2.removeValue(this._exp1.value() - this._offset);
        }
    }

    @Override
    protected void setSubjectTrue() throws Failure {
        this._exp1.setMax(this._exp2.max() + this._offset);
        this._exp2.setMax(this._exp1.max() - this._offset);
        this._exp1.setMin(this._exp2.min() + this._offset);
        this._exp2.setMin(this._exp1.min() - this._offset);
    }

    final class ObserverMinMax
    extends Observer {
        ObserverMinMax() {
        }

        @Override
        public Object master() {
            return IntBoolExpEqExp.this;
        }

        @Override
        public int subscriberMask() {
            return 15;
        }

        @Override
        public void update(Subject exp, EventOfInterest interest) throws Failure {
            IntBoolExpEqExp.this.setDomainMinMax();
        }
    }
}

