/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

public class IntBoolExpFloatLessExp
extends IntBoolExpForSubject {
    protected FloatExp _left;
    protected FloatExp _right;
    protected double _offset;
    private Observer _observer;

    public IntBoolExpFloatLessExp(FloatExp left, FloatExp right) {
        this(left, right, 0.0, left.constrainer(), "");
    }

    public IntBoolExpFloatLessExp(FloatExp left, FloatExp right, double offset) {
        this(left, right, offset, left.constrainer(), "");
    }

    public IntBoolExpFloatLessExp(FloatExp left, FloatExp right, double offset, Constrainer c, String name) {
        super(c, name);
        this._left = left;
        this._right = right;
        this._offset = offset;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + left.name() + "||" + right.name() + ")";
        }
        this.setDomainMinMaxSafe();
        this._observer = new ObserverMinMax();
        this._left.attachObserver(this._observer);
        this._right.attachObserver(this._observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._right.sub(this._left).add(this._offset).calcCoeffs(map, factor);
    }

    @Override
    public boolean isLinear() {
        return this._left.isLinear() && this._right.isLinear();
    }

    @Override
    public boolean isSubjectFalse() {
        return FloatCalc.gt(this._left.min(), this._right.max() + this._offset);
    }

    @Override
    public boolean isSubjectTrue() {
        return FloatCalc.ge(this._right.min() + this._offset, this._left.max());
    }

    @Override
    protected void setSubjectFalse() throws Failure {
        this._left.setMin(this._right.min() + this._offset);
        this._right.setMax(this._left.max() - this._offset);
    }

    @Override
    protected void setSubjectTrue() throws Failure {
        this._left.setMax(this._right.max() - this._offset);
        this._right.setMin(this._left.min() + this._offset);
    }

    class ObserverMinMax
    extends Observer {
        ObserverMinMax() {
        }

        @Override
        public Object master() {
            return IntBoolExpFloatLessExp.this;
        }

        @Override
        public int subscriberMask() {
            return 6;
        }

        @Override
        public void update(Subject subject, EventOfInterest interest) throws Failure {
            IntBoolExpFloatLessExp.this.setDomainMinMax();
        }
    }
}

