/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

public class IntBoolExpLessValue
extends IntBoolExpForSubject {
    protected IntExp _left;
    protected int _right;
    private Observer _observer;

    public IntBoolExpLessValue(IntExp left, int right) {
        this(left, right, left.constrainer(), "");
    }

    public IntBoolExpLessValue(IntExp left, int right, Constrainer c, String name) {
        super(c, name);
        this._left = left;
        this._right = right;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + left.name() + "<" + right + ")";
        }
        this.setDomainMinMaxSafe();
        this._observer = new ObserverMinMax();
        this._left.attachObserver(this._observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._left.neg().add(this._right).calcCoeffs(map, factor);
    }

    @Override
    public boolean isLinear() {
        return this._left.isLinear();
    }

    @Override
    protected boolean isSubjectFalse() {
        return this._left.min() >= this._right;
    }

    @Override
    protected boolean isSubjectTrue() {
        return this._left.max() < this._right;
    }

    @Override
    protected void setSubjectFalse() throws Failure {
        this._left.setMin(this._right);
    }

    @Override
    protected void setSubjectTrue() throws Failure {
        this._left.setMax(this._right - 1);
    }

    class ObserverMinMax
    extends Observer {
        ObserverMinMax() {
        }

        @Override
        public Object master() {
            return IntBoolExpLessValue.this;
        }

        @Override
        public int subscriberMask() {
            return 6;
        }

        @Override
        public void update(Subject subject, EventOfInterest interest) throws Failure {
            IntBoolExpLessValue.this.setDomainMinMax();
        }
    }
}

