/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpConst;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.impl.ConstraintExpEqualsExp;
import org.openl.ie.constrainer.impl.ConstraintExpEqualsValue;
import org.openl.ie.constrainer.impl.ConstraintExpLessExp;
import org.openl.ie.constrainer.impl.ConstraintExpLessValue;
import org.openl.ie.constrainer.impl.ConstraintExpMoreValue;
import org.openl.ie.constrainer.impl.ExpressionImpl;
import org.openl.ie.constrainer.impl.FloatExpAddExp;
import org.openl.ie.constrainer.impl.FloatExpIntExp;
import org.openl.ie.constrainer.impl.IntBoolExpEqExp;
import org.openl.ie.constrainer.impl.IntBoolExpEqValue;
import org.openl.ie.constrainer.impl.IntBoolExpLessExp;
import org.openl.ie.constrainer.impl.IntExpAbs;
import org.openl.ie.constrainer.impl.IntExpAddExp;
import org.openl.ie.constrainer.impl.IntExpAddValue;
import org.openl.ie.constrainer.impl.IntExpBitAndExp;
import org.openl.ie.constrainer.impl.IntExpDivExp;
import org.openl.ie.constrainer.impl.IntExpDivValue;
import org.openl.ie.constrainer.impl.IntExpMulExp;
import org.openl.ie.constrainer.impl.IntExpMultiplyPositive;
import org.openl.ie.constrainer.impl.IntExpOpposite;
import org.openl.ie.constrainer.impl.IntExpPowIntExp;
import org.openl.ie.constrainer.impl.IntExpPowIntValue;
import org.openl.ie.constrainer.impl.IntExpRangeViolation;
import org.openl.ie.constrainer.impl.IntExpSqr;

public abstract class IntExpImpl
extends ExpressionImpl
implements IntExp {
    public static String domainToString(int min, int max) {
        return min == max ? "[" + min + "]" : "[" + min + ".." + max + "]";
    }

    public IntExpImpl(Constrainer constrainer) {
        this(constrainer, "");
    }

    public IntExpImpl(Constrainer constrainer, String name) {
        super(constrainer, name);
    }

    @Override
    public IntExp abs() {
        if (this.min() >= 0) {
            return this;
        }
        if (this.max() <= 0) {
            return this.neg();
        }
        return this.getIntExp(IntExpAbs.class, this);
    }

    @Override
    public FloatExp add(double value) {
        return this.asFloat().add(value);
    }

    @Override
    public FloatExp add(FloatExp exp) {
        return this.getFloatExp(FloatExpAddExp.class, this.asFloat(), exp);
    }

    @Override
    public IntExp add(int value) {
        return this.getIntExp(IntExpAddValue.class, (IntExp)this, value);
    }

    @Override
    public IntExp add(IntExp exp) {
        return this.getIntExp(IntExpAddExp.class, (IntExp)this, exp);
    }

    @Override
    public FloatExp asFloat() {
        return this.getFloatExp(FloatExpIntExp.class, this);
    }

    @Override
    public IntExp bitAnd(IntExp exp) {
        return this.getIntExp(IntExpBitAndExp.class, (IntExp)this, exp);
    }

    @Override
    public boolean bound() {
        return this.min() == this.max();
    }

    @Override
    public double calcCoeffs(Map map) throws NonLinearExpression {
        return this.calcCoeffs(map, 1.0);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        throw new NonLinearExpression(this);
    }

    @Override
    public boolean contains(int value) {
        return value >= this.min() && value <= this.max();
    }

    @Override
    public FloatExp div(double c) {
        return this.asFloat().div(c);
    }

    @Override
    public IntExp div(int c) {
        if (c == 0) {
            throw new IllegalArgumentException("div(IntExp exp, int value): value == 0");
        }
        if (c == 1) {
            return this;
        }
        if (c == -1) {
            return this.neg();
        }
        return this.getIntExp(IntExpDivValue.class, (IntExp)this, c);
    }

    @Override
    public IntExp div(IntExp divisor) throws Failure {
        divisor.removeValue(0);
        if (divisor == this) {
            return new IntExpConst(this.constrainer(), 1);
        }
        if (divisor.bound()) {
            int value;
            try {
                value = divisor.value();
            }
            catch (Exception e) {
                value = 0;
            }
            return this.div(value);
        }
        return this.getIntExp(IntExpDivExp.class, (IntExp)this, divisor);
    }

    @Override
    public String domainToString() {
        return IntExpImpl.domainToString(this.min(), this.max());
    }

    @Override
    public IntBoolExp eq(double value) {
        return this.asFloat().eq(value);
    }

    @Override
    public IntBoolExp eq(int value) {
        return this.getIntBoolExp(IntBoolExpEqValue.class, (IntExp)this, value);
    }

    @Override
    public IntBoolExp eq(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpEqExp.class, (IntExp)this, exp);
    }

    public Constraint equals(FloatExp exp) {
        return exp.equals(this);
    }

    @Override
    public Constraint equals(FloatExp exp, double value) {
        return exp.equals(this, value);
    }

    @Override
    public Constraint equals(int value) {
        return new ConstraintExpEqualsValue(this, value);
    }

    @Override
    public Constraint equals(IntExp exp) {
        return new ConstraintExpEqualsExp(this, exp);
    }

    @Override
    public Constraint equals(IntExp exp, int value) {
        return new ConstraintExpEqualsExp(this, exp, value);
    }

    @Override
    public IntBoolExp ge(double value) {
        return this.asFloat().ge(value);
    }

    @Override
    public IntBoolExp ge(int value) {
        return this.gt(value - 1);
    }

    @Override
    public IntBoolExp ge(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpLessExp.class, exp, this, 1);
    }

    @Override
    public IntBoolExp gt(double value) {
        return this.asFloat().gt(value);
    }

    @Override
    public IntBoolExp gt(int value) {
        return this.gt(this.getIntExp(IntExpConst.class, value));
    }

    @Override
    public IntBoolExp gt(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpLessExp.class, exp, this);
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        for (int i = this.min(); i <= this.max(); ++i) {
            boolean res;
            if (!this.contains(i) || (res = it.doSomethingOrStop(i))) continue;
            return;
        }
    }

    @Override
    public IntBoolExp le(double value) {
        return this.asFloat().le(value);
    }

    @Override
    public IntBoolExp le(int value) {
        return this.lt(value + 1);
    }

    @Override
    public IntBoolExp le(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpLessExp.class, this, exp, 1);
    }

    @Override
    public Constraint less(int value) {
        return new ConstraintExpLessValue(this, value);
    }

    @Override
    public Constraint less(IntExp exp) {
        return new ConstraintExpLessExp(this, exp, 1);
    }

    @Override
    public Constraint lessOrEqual(FloatExp exp) {
        return exp.moreOrEqual(this);
    }

    @Override
    public Constraint lessOrEqual(int value) {
        return this.less(value + 1);
    }

    @Override
    public Constraint lessOrEqual(IntExp exp) {
        return new ConstraintExpLessExp(this, exp, 0);
    }

    @Override
    public IntBoolExp lt(double value) {
        return this.asFloat().lt(value);
    }

    @Override
    public IntBoolExp lt(int value) {
        return this.lt(this.getIntExp(IntExpConst.class, value));
    }

    @Override
    public IntBoolExp lt(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpLessExp.class, (IntExp)this, exp);
    }

    @Override
    public FloatExp mod(double c) {
        throw new UnsupportedOperationException("mod");
    }

    @Override
    public IntExp mod(int c) {
        throw new UnsupportedOperationException("mod");
    }

    @Override
    public Constraint more(int value) {
        return new ConstraintExpMoreValue(this, value);
    }

    @Override
    public Constraint more(IntExp exp) {
        return new ConstraintExpLessExp(exp, this, 1);
    }

    @Override
    public Constraint moreOrEqual(FloatExp exp) {
        return exp.lessOrEqual(this);
    }

    @Override
    public Constraint moreOrEqual(int value) {
        return this.more(value - 1);
    }

    @Override
    public Constraint moreOrEqual(IntExp exp) {
        return new ConstraintExpLessExp(exp, this, 0);
    }

    @Override
    public FloatExp mul(double c) {
        return this.asFloat().mul(c);
    }

    @Override
    public FloatExp mul(FloatExp exp) {
        return exp.mul(this);
    }

    @Override
    public IntExp mul(int c) {
        if (c == 1) {
            return this;
        }
        if (c > 0) {
            return this.getIntExp(IntExpMultiplyPositive.class, (IntExp)this, c);
        }
        if (c == 0) {
            return this.getIntExp(IntExpConst.class, 0);
        }
        return this.neg().mul(-c);
    }

    @Override
    public IntExp mul(IntExp exp) {
        if (exp.bound()) {
            return this.mul(exp.max());
        }
        if (exp == this) {
            return this.sqr();
        }
        return this.mul_1(exp);
    }

    IntExp mul_1(IntExp exp) {
        return this.getIntExp(IntExpMulExp.class, (IntExp)this, exp);
    }

    @Override
    public IntBoolExp ne(double value) {
        return this.asFloat().ne(value);
    }

    @Override
    public IntBoolExp ne(int value) {
        return this.ne(this.getIntExp(IntExpConst.class, value));
    }

    @Override
    public IntBoolExp ne(IntExp exp) {
        return this.getIntBoolExp(IntBoolExpEqExp.class, (IntExp)this, exp).not();
    }

    @Override
    public IntExp neg() {
        return this.getIntExp(IntExpOpposite.class, this);
    }

    @Override
    public FloatExp pow(double value) throws Failure {
        return this.asFloat().pow(value);
    }

    @Override
    public IntExp pow(int value) {
        switch (value) {
            case 0: {
                return this.getIntExp(IntExpConst.class, 1);
            }
            case 1: {
                return this;
            }
            case 2: {
                return this.sqr();
            }
        }
        if (value > 0) {
            return this.getIntExp(IntExpPowIntValue.class, (IntExp)this, value);
        }
        throw new IllegalArgumentException("pow(IntExp exp, int value): value < 0");
    }

    @Override
    public IntExp pow(IntExp pow_exp) throws Failure {
        if (pow_exp.max() < 0) {
            throw new IllegalArgumentException("pow(IntExp exp, IntExp pow_exp): pow_exp < 0");
        }
        pow_exp.setMin(0);
        return this.getIntExp(IntExpPowIntExp.class, (IntExp)this, pow_exp);
    }

    @Override
    public void propagate() throws Failure {
    }

    @Override
    public IntExp rangeViolation(int rangeMin, int rangeMax) {
        return (IntExp)this.getExpression(IntExpRangeViolation.class, new Object[]{this, new Integer(rangeMin), new Integer(rangeMax)});
    }

    @Override
    public void removeRange(int min, int max) throws Failure {
        this.removeRangeInternal(min, max);
    }

    protected void removeRangeInternal(int min, int max) throws Failure {
    }

    @Override
    public void removeValue(int value) throws Failure {
        int min = this.min();
        if (value == min) {
            this.setMin(min + 1);
        } else {
            int max = this.max();
            if (value == max) {
                this.setMax(max - 1);
            } else {
                this.removeValueInternal(value);
            }
        }
    }

    protected void removeValueInternal(int value) throws Failure {
    }

    @Override
    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public int size() {
        return this.max() - this.min() + 1;
    }

    @Override
    public IntExp sqr() {
        return this.getIntExp(IntExpSqr.class, this);
    }

    @Override
    public FloatExp sub(double value) {
        return this.add(-value);
    }

    @Override
    public FloatExp sub(FloatExp exp) {
        return this.add(exp.neg());
    }

    @Override
    public IntExp sub(int value) {
        return this.add(-value);
    }

    @Override
    public IntExp sub(IntExp exp) {
        return this.add(exp.neg());
    }

    @Override
    public String toString() {
        return this.name() + this.domainToString();
    }

    @Override
    public boolean valid() {
        return this.min() <= this.max();
    }

    @Override
    public int value() throws Failure {
        int min = this.min();
        if (min != this.max()) {
            this._constrainer.fail("Attempt to get value of an unbound expression" + this);
        }
        return min;
    }

    @Override
    public int valueUnsafe() {
        return this.min();
    }
}

