/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.openl.ie.simplex.Direction;
import org.openl.ie.simplex.IPSErrorCodes;
import org.openl.ie.simplex.LPClass;
import org.openl.ie.simplex.LPErrorCodes;
import org.openl.ie.simplex.MIPErrorCodes;
import org.openl.ie.simplex.NoSolutionException;
import org.openl.ie.simplex.NotAMIPProblem;
import org.openl.ie.simplex.Param;
import org.openl.ie.simplex.SolutionErrorCodes;
import org.openl.ie.simplex.Status;
import org.openl.ie.simplex.VarInfo;
import org.openl.ie.simplex.VarKind;
import org.openl.ie.simplex.VarType;
import org.openl.ie.simplex.WrongLPX;
import org.openl.util.Log;

public class LPX {
    private int id = -1;
    private int nbRows = 0;
    private int nbCols = 0;
    private int nbMarkedRows = 0;
    private int nbMarkedColumns = 0;

    private static boolean isAllDiff(int[] arr) {
        for (int i = 0; i < arr.length - 1; ++i) {
            for (int j = i + 1; j < arr.length; ++j) {
                if (arr[i] != arr[j]) continue;
                return false;
            }
        }
        return true;
    }

    public void addColumns(int num) throws WrongLPX {
        this.ensureLPXCreated();
        this.native_add_cols(this.id, num);
        this.nbCols += num;
    }

    public void addRows(int num) throws WrongLPX {
        this.ensureLPXCreated();
        this.native_add_rows(this.id, num);
        this.nbRows += num;
    }

    public void clearMat() throws WrongLPX {
        this.ensureLPXCreated();
        if (this.nbMarkedColumns != 0 || this.nbMarkedRows != 0) {
            this.native_clear_mat(this.id);
        }
    }

    public void createLPX() {
        if (this.id == -1) {
            this.id = this.native_create_lpx();
        }
    }

    public void deleteLPX() {
        if (this.noLPX()) {
            return;
        }
        this.native_delete_lpx(this.id);
        this.id = -1;
    }

    public void delItems() throws WrongLPX {
        this.ensureLPXCreated();
        if (this.nbMarkedColumns != 0 || this.nbMarkedRows != 0) {
            this.native_del_items(this.id);
            this.nbRows -= this.nbMarkedRows;
            this.nbCols -= this.nbMarkedColumns;
            this.nbMarkedRows = 0;
            this.nbMarkedColumns = 0;
        }
    }

    private void ensureColumnExist(int colnum) throws WrongLPX {
        this.ensureLPXCreated();
        if (this.nbCols <= colnum) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void ensureLPXCreated() throws WrongLPX {
        if (this.id == -1) {
            throw new WrongLPX();
        }
    }

    private void ensureRowExist(int rownum) throws WrongLPX {
        this.ensureLPXCreated();
        if (this.nbRows <= rownum) {
            throw new IndexOutOfBoundsException();
        }
    }

    public VarInfo getAuxInfo(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        return new VarInfo(this.native_get_row_info(this.id, rownum + 1));
    }

    public VarInfo getBasicInfo(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        return new VarInfo(this.native_get_col_info(this.id, colnum + 1));
    }

    public double getBoolParm(int parm) throws WrongLPX {
        this.ensureLPXCreated();
        if (!Param.isValidBoolParam(parm)) {
            throw new IllegalArgumentException("GetBoolParm: unknown parameter: " + parm);
        }
        return this.native_get_int_parm(this.id, Param.getParam(parm));
    }

    public VarType getColBnds(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        double[] temp = this.native_get_col_bnds(this.id, colnum + 1);
        return new VarType((int)temp[0], temp[1], temp[2]);
    }

    public double getColCoef(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        return this.native_get_col_coef(this.id, colnum + 1);
    }

    public String getColName(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        return this.native_get_col_name(this.id, colnum + 1);
    }

    public int getDualStatus() throws WrongLPX {
        this.ensureLPXCreated();
        return this.native_get_dual_status(this.id);
    }

    public int getIntParm(int parm) throws WrongLPX {
        this.ensureLPXCreated();
        if (parm == 100) {
            return this.native_get_total_memory_used(this.id);
        }
        if (!Param.isValidIntParam(parm)) {
            throw new IllegalArgumentException("GetIntParm: unknown parameter: " + parm);
        }
        return this.native_get_int_parm(this.id, Param.getParam(parm));
    }

    public VarInfo getIPSColInfo(int colnum) throws WrongLPX {
        this.ensureRowExist(colnum);
        return new VarInfo(this.native_get_ips_col(this.id, colnum + 1));
    }

    public double getIPSObjValue() throws WrongLPX, NoSolutionException {
        this.ensureLPXCreated();
        int status = this.getIPSStatus();
        if (!IPSErrorCodes.isOptimal(status)) {
            throw new NoSolutionException(Status.translate(status));
        }
        return this.native_get_ips_obj(this.id);
    }

    public VarInfo getIPSRowInfo(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        return new VarInfo(this.native_get_ips_row(this.id, rownum + 1));
    }

    public int getIPSStatus() {
        if (this.noLPX()) {
            return 3001;
        }
        return this.native_get_ips_stat(this.id);
    }

    public double[] getMatCols(int colnum) throws WrongLPX {
        this.ensureRowExist(colnum);
        double[] temp = this.native_get_mat_row(this.id, colnum + 1);
        double[] col = new double[this.nbCols];
        int halfsize = temp.length / 2;
        for (int i = 0; i < halfsize; ++i) {
            col[(int)temp[halfsize + i] - 1] = temp[i];
        }
        return col;
    }

    public double[] getMatRow(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        double[] temp = this.native_get_mat_row(this.id, rownum + 1);
        double[] row = new double[this.nbCols];
        int halfsize = temp.length / 2;
        for (int i = 0; i < halfsize; ++i) {
            row[(int)temp[halfsize + i] - 1] = temp[i];
        }
        return row;
    }

    public double getMIPAux(int rownum) throws WrongLPX, NotAMIPProblem {
        this.ensureRowExist(rownum);
        if (!this.isMIP()) {
            throw new NotAMIPProblem();
        }
        return this.native_get_mip_row(this.id, rownum + 1);
    }

    public double getMIPBasic(int colnum) throws WrongLPX, NotAMIPProblem {
        this.ensureColumnExist(colnum);
        if (!this.isMIP()) {
            throw new NotAMIPProblem();
        }
        return this.native_get_mip_col(this.id, colnum + 1);
    }

    public double getMIPObjVal() throws WrongLPX, NoSolutionException {
        this.ensureLPXCreated();
        this.processMIPSolution();
        return this.native_get_mip_obj(this.id);
    }

    public int getMIPStatus() {
        if (this.noLPX()) {
            return 3001;
        }
        if (!this.isMIP()) {
            return 3000;
        }
        return this.native_get_mip_stat(this.id);
    }

    public String getName() {
        if (this.noLPX()) {
            return "";
        }
        return this.native_get_name(this.id);
    }

    public int getNumBoolVars() {
        if (this.noLPX() || !this.isMIP()) {
            return 0;
        }
        return this.native_get_num_bin(this.id);
    }

    public int getNumCols() {
        if (this.noLPX()) {
            return 0;
        }
        return this.native_get_num_cols(this.id);
    }

    public int getNumIntVars() {
        if (this.noLPX() || !this.isMIP()) {
            return 0;
        }
        return this.native_get_num_int(this.id);
    }

    public int getNumNz() {
        if (this.noLPX()) {
            return 0;
        }
        return this.native_get_num_nz(this.id);
    }

    public int getNumRows() {
        if (this.noLPX()) {
            return 0;
        }
        return this.native_get_num_rows(this.id);
    }

    public double getObjConst() throws WrongLPX {
        if (this.noLPX()) {
            return 0.0;
        }
        return this.native_get_obj_c0(this.id);
    }

    public int getObjDir() {
        if (this.noLPX()) {
            return -1;
        }
        return this.native_get_obj_dir(this.id);
    }

    public double getObjVal() throws WrongLPX, NoSolutionException {
        this.solutionProcess();
        return this.native_get_obj_val(this.id);
    }

    public int getPrimStatus() throws WrongLPX {
        this.ensureLPXCreated();
        return this.native_get_prim_status(this.id);
    }

    public double getRealParm(int parm) throws WrongLPX {
        this.ensureLPXCreated();
        if (!Param.isValidIntParam(parm)) {
            throw new IllegalArgumentException("GetRealParm: unknown parameter: " + parm);
        }
        return this.native_get_real_parm(this.id, Param.getParam(parm));
    }

    public VarType getRowBnds(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        double[] temp = this.native_get_row_bnds(this.id, rownum + 1);
        return new VarType((int)temp[0], temp[1], temp[2]);
    }

    public double getRowCoef(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        return this.native_get_col_coef(this.id, rownum + 1);
    }

    public String getRowName(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        return this.native_get_row_name(this.id, rownum + 1);
    }

    public int getStatus() {
        if (this.noLPX()) {
            return 3001;
        }
        return this.native_get_status(this.id);
    }

    public int interiorPointSolve() {
        if (this.noLPX()) {
            return 3001;
        }
        return this.native_interior(this.id);
    }

    public boolean isIntVar(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        int flag = this.native_get_col_kind(this.id, colnum + 1);
        return flag == VarKind.INT_VAR;
    }

    public boolean isMIP() {
        if (this.noLPX()) {
            return false;
        }
        int flag = this.native_get_type(this.id);
        return flag == LPClass.LPX_MIP;
    }

    public void makeVarInt(int colnum) throws WrongLPX, NotAMIPProblem {
        this.ensureColumnExist(colnum);
        if (!this.isMIP()) {
            throw new NotAMIPProblem();
        }
        this.native_set_col_kind(this.id, colnum + 1, VarKind.INT_VAR);
    }

    public void makeVarReal(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        this.native_set_col_kind(this.id, colnum + 1, VarKind.REAL_VAR);
    }

    public void markColumn(int colnum) throws WrongLPX {
        this.ensureColumnExist(colnum);
        this.native_mark_col(this.id, colnum + 1, 1);
        ++this.nbMarkedColumns;
    }

    public void markRow(int rownum) throws WrongLPX {
        this.ensureRowExist(rownum);
        this.native_mark_row(this.id, rownum + 1, 1);
        ++this.nbMarkedRows;
    }

    private native void native_add_cols(int var1, int var2);

    private native void native_add_rows(int var1, int var2);

    private native void native_clear_mat(int var1);

    private native int native_create_lpx();

    private native void native_del_items(int var1);

    private native void native_delete_lpx(int var1);

    private native double[] native_get_col_bnds(int var1, int var2);

    private native double native_get_col_coef(int var1, int var2);

    private native double[] native_get_col_info(int var1);

    private native double[] native_get_col_info(int var1, int var2);

    private native int native_get_col_kind(int var1, int var2);

    private native String native_get_col_name(int var1, int var2);

    private native int native_get_dual_status(int var1);

    private native int native_get_int_parm(int var1, int var2);

    private native double[] native_get_ips_col(int var1, int var2);

    private native double native_get_ips_obj(int var1);

    private native double[] native_get_ips_row(int var1, int var2);

    private native int native_get_ips_stat(int var1);

    private native double[] native_get_mat_col(int var1, int var2);

    private native double[] native_get_mat_row(int var1, int var2);

    private native double native_get_mip_col(int var1, int var2);

    private native double native_get_mip_obj(int var1);

    private native double native_get_mip_row(int var1, int var2);

    private native int native_get_mip_stat(int var1);

    private native String native_get_name(int var1);

    private native int native_get_num_bin(int var1);

    private native int native_get_num_cols(int var1);

    private native int native_get_num_int(int var1);

    private native int native_get_num_nz(int var1);

    private native int native_get_num_rows(int var1);

    private native double native_get_obj_c0(int var1);

    private native int native_get_obj_dir(int var1);

    private native double native_get_obj_val(int var1);

    private native int native_get_prim_status(int var1);

    private native double native_get_real_parm(int var1, int var2);

    private native double[] native_get_row_bnds(int var1, int var2);

    private native double native_get_row_coef(int var1, int var2);

    private native double[] native_get_row_info(int var1, int var2);

    private native String native_get_row_name(int var1, int var2);

    private native int native_get_status(int var1);

    private native int native_get_total_memory_used(int var1);

    private native int native_get_type(int var1);

    private native int native_integer(int var1);

    private native int native_interior(int var1);

    private native void native_mark_col(int var1, int var2, int var3);

    private native void native_mark_row(int var1, int var2, int var3);

    private native void native_print_ips(int var1, String var2);

    private native void native_print_mip(int var1, String var2);

    private native void native_print_solution(int var1, String var2);

    private native void native_read_lp(int var1, String var2);

    private native void native_read_mps(int var1, String var2);

    private native void native_reset_parm(int var1);

    private native void native_set_col_bnds(int var1, int var2, int var3, double var4, double var6);

    private native void native_set_col_coef(int var1, int var2, double var3);

    private native void native_set_col_kind(int var1, int var2, int var3);

    private native void native_set_col_name(int var1, int var2, String var3);

    private native void native_set_int_parm(int var1, int var2, int var3);

    private native void native_set_mat_col(int var1, int var2, int[] var3, double[] var4);

    private native void native_set_mat_row(int var1, int var2, int[] var3, double[] var4);

    private native void native_set_name(int var1, String var2);

    private native void native_set_obj_c0(int var1, double var2);

    private native void native_set_obj_dir(int var1, int var2);

    private native void native_set_real_parm(int var1, int var2, double var3);

    private native void native_set_row_bnds(int var1, int var2, int var3, double var4, double var6);

    private native void native_set_row_coef(int var1, int var2, double var3);

    private native void native_set_row_name(int var1, int var2, String var3);

    private native void native_set_type(int var1, int var2);

    private native int native_simplex_solve(int var1);

    private native void native_unmark_all(int var1);

    private native void native_write_mps(int var1, String var2);

    private boolean noLPX() {
        return this.id == -1;
    }

    public void printIPSolution(String fname) {
        int status = this.getIPSStatus();
        if (!IPSErrorCodes.isOptimal(status)) {
            try {
                DataOutputStream odstr = new DataOutputStream(new FileOutputStream(fname));
                odstr.writeBytes(Status.translate(status));
            }
            catch (FileNotFoundException ex) {
                Log.error((Object)("attempt to open the file denoted by a specified pathname \"" + fname + "\" has failed"));
            }
            catch (Exception ex) {
                Log.error((Object)"printSolution(String) has failed for some reason");
            }
        } else {
            this.native_print_ips(this.id, fname);
        }
    }

    public void printMIPSolution(String fname) {
        int status = this.getMIPStatus();
        if (!MIPErrorCodes.isFeasible(status)) {
            try {
                DataOutputStream odstr = new DataOutputStream(new FileOutputStream(fname));
                odstr.writeBytes(Status.translate(status));
            }
            catch (FileNotFoundException ex) {
                Log.error((Object)("attempt to open the file denoted by a specified pathname \"" + fname + "\" has failed"));
            }
            catch (Exception ex) {
                Log.error((Object)"printSolution(String) has failed for some reason");
            }
        } else {
            this.native_print_mip(this.id, fname);
        }
    }

    public void printSolution(String fname) {
        int status = this.getStatus();
        if (!LPErrorCodes.isFeasible(status)) {
            try {
                DataOutputStream odstr = new DataOutputStream(new FileOutputStream(fname));
                odstr.writeBytes(Status.translate(status));
            }
            catch (FileNotFoundException ex) {
                Log.error((Object)("Attempt to open the file denoted by a specified pathname \"" + fname + "\" has failed"));
            }
            catch (Exception ex) {
                Log.error((Object)"printSolution(String) has failed for some reason");
            }
        } else {
            this.native_print_solution(this.id, fname);
        }
    }

    public void processMIPSolution() throws WrongLPX, NoSolutionException {
        int status = this.native_get_mip_stat(this.id);
        if (!MIPErrorCodes.isFeasible(status)) {
            throw new NoSolutionException(Status.translate(status));
        }
    }

    public void readLP(String fname) {
        if (this.id == -1) {
            this.id = this.native_create_lpx();
        }
        this.native_read_lp(this.id, fname);
        this.nbRows = this.native_get_num_rows(this.id);
        this.nbCols = this.native_get_num_cols(this.id);
        this.nbMarkedColumns = 0;
        this.nbMarkedRows = 0;
    }

    public void readMPS(String fname) {
        if (this.id == -1) {
            this.id = this.native_create_lpx();
        }
        this.native_read_mps(this.id, fname);
        this.nbRows = this.native_get_num_rows(this.id);
        this.nbCols = this.native_get_num_cols(this.id);
        this.nbMarkedColumns = 0;
        this.nbMarkedRows = 0;
    }

    public void removeMIPStatus() {
        if (this.noLPX()) {
            return;
        }
        this.native_set_type(this.id, LPClass.LPX_PURE);
    }

    public void resetParms() {
        if (!this.noLPX()) {
            this.native_reset_parm(this.id);
        }
    }

    public void saveLPtoMPSFormat(String fname) {
        if (this.noLPX()) {
            try {
                DataOutputStream odstr = new DataOutputStream(new FileOutputStream(fname));
                odstr.writeBytes("LPX hasn't been created");
            }
            catch (FileNotFoundException ex) {
                Log.error((Object)("attempt to open the file denoted by a specified pathname \"" + fname + "\" has failed"));
            }
            catch (Exception ex) {
                Log.error((Object)"saveLPtoMPSFormat(String) has failed due to some IO error");
            }
        } else {
            this.native_write_mps(this.id, fname);
        }
    }

    public void setBoolParm(int parm, boolean val) {
        if (this.noLPX()) {
            return;
        }
        if (!Param.isValidBoolParam(parm)) {
            throw new IllegalArgumentException("SetBoolParm: unsupported arguments: param = " + parm + ", value= " + val);
        }
        this.native_set_int_parm(this.id, Param.getParam(parm), val ? 1 : 0);
    }

    public void setColBnds(int colnum, int type, double lb, double ub) throws WrongLPX {
        this.ensureColumnExist(colnum);
        VarType vt = new VarType(type, lb, ub);
        this.native_set_col_bnds(this.id, colnum + 1, vt.getType(), vt.getLb(), vt.getUb());
    }

    public void setColCoef(int colnum, double coef) throws WrongLPX {
        this.ensureColumnExist(colnum);
        this.native_set_col_coef(this.id, colnum + 1, coef);
    }

    public void setColName(int colnum, String name) {
        if (this.noLPX()) {
            return;
        }
        if (colnum >= this.nbCols) {
            throw new IndexOutOfBoundsException();
        }
        this.native_set_col_name(this.id, colnum + 1, name);
    }

    public void setIntParm(int parm, int val) {
        if (this.noLPX()) {
            return;
        }
        if (!Param.isValidIntParam(parm, val)) {
            throw new IllegalArgumentException("SetIntParm: unsupported arguments: param = " + parm + ", value= " + val);
        }
        this.native_set_int_parm(this.id, Param.getParam(parm), val);
    }

    public void setMatCol(int colnum, double[] values) throws WrongLPX {
        this.ensureRowExist(colnum);
        if (values.length != this.nbCols) {
            throw new IllegalArgumentException("Array's length must be equal to the dimensionality of LP");
        }
        int nz = 0;
        int[] locations = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0) continue;
            locations[nz] = i;
            ++nz;
        }
        if (nz == 0) {
            throw new IllegalArgumentException("Nill array");
        }
        int[] locs = new int[nz + 1];
        double[] vals = new double[nz + 1];
        for (int i = 1; i <= nz; ++i) {
            locs[i] = locations[i - 1] + 1;
            vals[i] = values[locations[i - 1]];
        }
        this.native_set_mat_row(this.id, colnum + 1, locs, vals);
    }

    public void setMatCol(int colnum, int[] locations, double[] values) throws WrongLPX {
        this.ensureRowExist(colnum);
        String errStr = "setMatCol(int, int[], double[]): ";
        if (locations.length != values.length) {
            throw new IllegalArgumentException(errStr + "The second and the third arguments must be arrays of the same length");
        }
        if (locations.length > this.nbCols + 1) {
            throw new IllegalArgumentException(errStr + "Array's length must not be greater then dimensionality of LP");
        }
        for (int i = 0; i < locations.length; ++i) {
            if (locations[i] < 0 || locations[i] >= this.nbCols) {
                throw new IllegalArgumentException(errStr + "locations[" + i + "]=" + locations[i] + " : must be within the range [0.." + (this.nbRows - 1) + "]");
            }
            int n = i;
            locations[n] = locations[n] + 1;
            if (values[i] != 0.0) continue;
            throw new IllegalArgumentException(errStr + "values[" + i + "]=0" + ": can't contain nill elements");
        }
        if (!LPX.isAllDiff(locations)) {
            throw new IllegalArgumentException(errStr + " \"locations\" array must not contain identical elements");
        }
        int[] locs = new int[values.length + 1];
        double[] vals = new double[values.length + 1];
        System.arraycopy(locations, 0, locs, 1, values.length);
        System.arraycopy(values, 0, vals, 1, values.length);
        this.native_set_mat_row(this.id, colnum + 1, locs, vals);
    }

    public void setMatRow(int rownum, double[] values) throws WrongLPX {
        this.ensureRowExist(rownum);
        if (values.length != this.nbCols) {
            throw new IllegalArgumentException("Array's length must be equal to the dimensionality of LP");
        }
        int nz = 0;
        int[] locations = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0) continue;
            locations[nz] = i;
            ++nz;
        }
        if (nz == 0) {
            throw new IllegalArgumentException("Nill array");
        }
        int[] locs = new int[nz + 1];
        double[] vals = new double[nz + 1];
        for (int i = 1; i <= nz; ++i) {
            locs[i] = locations[i - 1] + 1;
            vals[i] = values[locations[i - 1]];
        }
        this.native_set_mat_row(this.id, rownum + 1, locs, vals);
    }

    public void setMatRow(int rownum, int[] locations, double[] values) throws WrongLPX {
        this.ensureRowExist(rownum);
        String errStr = "setMatRow(int,int[],double[]) :";
        if (locations.length != values.length) {
            throw new IllegalArgumentException(errStr + "The second and the third arguments must be arrays of the same length");
        }
        if (locations.length > this.nbCols + 1) {
            throw new IllegalArgumentException(errStr + "Array's length must not be greater then dimensionality of LP");
        }
        int i = 0;
        while (i < locations.length) {
            if (locations[i] < 0 || locations[i] >= this.nbCols) {
                throw new IllegalArgumentException(errStr + "locations[" + i + "]=" + locations[i] + " : must be within the range [0.." + (this.nbCols - 1) + "]");
            }
            if (values[i] == 0.0) {
                throw new IllegalArgumentException(errStr + "values[" + i + "]=0" + ": can't contain nill elements");
            }
            int n = i++;
            locations[n] = locations[n] + 1;
        }
        if (!LPX.isAllDiff(locations)) {
            throw new IllegalArgumentException(errStr + "\"locations\" array must not contain identical elements");
        }
        int[] locs = new int[values.length + 1];
        double[] vals = new double[values.length + 1];
        System.arraycopy(locations, 0, locs, 1, values.length);
        System.arraycopy(values, 0, vals, 1, values.length);
        this.native_set_mat_row(this.id, rownum + 1, locs, vals);
    }

    public void setMIPStatus() throws WrongLPX {
        this.ensureLPXCreated();
        this.native_set_type(this.id, LPClass.LPX_MIP);
    }

    public void setName(String name) throws WrongLPX {
        this.ensureLPXCreated();
        this.native_set_name(this.id, name);
    }

    public void setObjConst(double val) throws WrongLPX {
        this.ensureLPXCreated();
        this.native_set_obj_c0(this.id, val);
    }

    public void setObjDir(int dirType) throws WrongLPX {
        this.ensureLPXCreated();
        if (dirType == Direction.MAX) {
            this.native_set_obj_dir(this.id, dirType);
        } else {
            this.native_set_obj_dir(this.id, Direction.MIN);
        }
    }

    public void setRealParm(int parm, double val) {
        if (this.noLPX()) {
            return;
        }
        if (!Param.isValidRealParam(parm, val)) {
            throw new IllegalArgumentException("SetRealParm: unsupported arguments: param = " + parm + ", value= " + val);
        }
        this.native_set_real_parm(this.id, Param.getParam(parm), val);
    }

    public void setRowBnds(int rownum, int type, double lb, double ub) throws WrongLPX {
        this.ensureRowExist(rownum);
        VarType vartype = new VarType(type, lb, ub);
        this.native_set_row_bnds(this.id, rownum + 1, vartype.getType(), vartype.getLb(), vartype.getUb());
    }

    public void setRowCoef(int rownum, double coef) throws WrongLPX {
        this.ensureRowExist(rownum);
        this.native_set_col_coef(this.id, rownum + 1, coef);
    }

    public void setRowName(int rownum, String name) {
        if (this.noLPX()) {
            return;
        }
        if (rownum >= this.nbRows) {
            throw new IndexOutOfBoundsException();
        }
        this.native_set_row_name(this.id, rownum + 1, name);
    }

    public int simplexSolve() {
        if (this.noLPX()) {
            return 3001;
        }
        return this.native_simplex_solve(this.id);
    }

    public void solutionProcess() throws NoSolutionException {
        int status = this.getStatus();
        if (LPErrorCodes.isFeasible(status)) {
            return;
        }
        throw new NoSolutionException(Status.translate(status));
    }

    public int solveMIP() {
        if (this.noLPX()) {
            return 3001;
        }
        if (!this.isMIP()) {
            return 3000;
        }
        int status = this.native_get_status(this.id);
        if (status == LPErrorCodes.LPX_UNDEF) {
            status = this.simplexSolve();
            if (!SolutionErrorCodes.isSuccessful(status)) {
                return SolutionErrorCodes.LPX_E_FAULT;
            }
            return this.native_integer(this.id);
        }
        if (!LPErrorCodes.isOptimal(status)) {
            return SolutionErrorCodes.LPX_E_FAULT;
        }
        return this.native_integer(this.id);
    }

    public void unmarkAll() throws WrongLPX {
        this.ensureLPXCreated();
        if (this.nbMarkedColumns != 0 || this.nbMarkedRows != 0) {
            this.native_unmark_all(this.id);
            this.nbMarkedRows = 0;
            this.nbMarkedColumns = 0;
        }
    }

    static {
        String dllName = "glpDll";
        File dllFile = new File(System.mapLibraryName(dllName));
        if (dllFile.exists()) {
            System.load(dllFile.getAbsolutePath());
        } else {
            System.loadLibrary(dllName);
        }
    }
}

