/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.Arrays;
import java.util.Comparator;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.FloatExp;

public final class FloatExpArray
extends ConstrainerObjectImpl {
    private FloatExp[] _data;

    public FloatExpArray(Constrainer c, int size) {
        super(c);
        this._data = new FloatExp[size];
    }

    public FloatExp[] data() {
        return this._data;
    }

    public FloatExp elementAt(int idx) {
        return this._data[idx];
    }

    public FloatExp get(int idx) {
        return this._data[idx];
    }

    public double max() {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this._data.length; ++i) {
            double maxi = this._data[i].max();
            if (!(maxi > max)) continue;
            max = maxi;
        }
        return max;
    }

    public double min() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this._data.length; ++i) {
            double mini = this._data[i].min();
            if (!(mini < min)) continue;
            min = mini;
        }
        return min;
    }

    @Override
    public void name(String name) {
        this.symbolicName(name);
    }

    public void set(FloatExp exp, int idx) {
        this._data[idx] = exp;
    }

    public int size() {
        return this._data.length;
    }

    public void sort(Comparator c) {
        Arrays.sort(this._data, c);
    }
}

