/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.Vector;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.impl.IntExpElementAt;

public final class IntArray
extends ConstrainerObjectImpl {
    private int[] _data;

    public IntArray(Constrainer c, int size) {
        super(c);
        this._data = new int[size];
    }

    public IntArray(Constrainer c, int e0, int e1) {
        this(c, 2);
        this._data[0] = e0;
        this._data[1] = e1;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2) {
        this(c, 3);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2, int e3) {
        this(c, 4);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2, int e3, int e4) {
        this(c, 5);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2, int e3, int e4, int e5) {
        this(c, 6);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2, int e3, int e4, int e5, int e6) {
        this(c, 7);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2, int e3, int e4, int e5, int e6, int e7) {
        this(c, 8);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
    }

    public IntArray(Constrainer c, int e0, int e1, int e2, int e3, int e4, int e5, int e6, int e7, int e8) {
        this(c, 9);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
        this._data[8] = e8;
    }

    public IntArray(Constrainer c, int size, String name) {
        super(c, name);
        this._data = new int[size];
    }

    public IntArray(Constrainer c, int[] arr) {
        this(c, arr.length);
        System.arraycopy(arr, 0, this._data, 0, this._data.length);
    }

    public IntArray(Constrainer c, Vector v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (Integer)v.elementAt(i);
        }
    }

    public int[] data() {
        return this._data;
    }

    public int elementAt(int idx) {
        return this.get(idx);
    }

    public IntExp elementAt(IntExp idx_exp) {
        return new IntExpElementAt(this, idx_exp);
    }

    public int get(int idx) {
        return this._data[idx];
    }

    public int max() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this._data.length; ++i) {
            int maxi = this._data[i];
            if (maxi <= max) continue;
            max = maxi;
        }
        return max;
    }

    IntArray merge(IntArray array) {
        int i;
        int[] new_data = new int[this._data.length + array._data.length];
        int index = 0;
        for (i = 0; i < this._data.length; ++i) {
            new_data[index] = this._data[i];
            ++index;
        }
        for (i = 0; i < array._data.length; ++i) {
            new_data[index] = array._data[i];
            ++index;
        }
        return new IntArray(this.constrainer(), new_data);
    }

    public int min() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this._data.length; ++i) {
            int mini = this._data[i];
            if (mini >= min) continue;
            min = mini;
        }
        return min;
    }

    @Override
    public void name(String name) {
        this.symbolicName(name);
    }

    public void set(int value, int idx) {
        this._data[idx] = value;
    }

    public int size() {
        return this._data.length;
    }

    IntArray subarray(int min_index, int max_index) {
        if (min_index > max_index) {
            return new IntArray(this.constrainer(), 0);
        }
        int[] sub_data = new int[max_index - min_index + 1];
        System.arraycopy(this._data, min_index, sub_data, 0, max_index + 1 - min_index);
        return new IntArray(this.constrainer(), sub_data);
    }

    IntArray subarrayByMask(boolean[] mask) {
        int i;
        int a_size = Math.min(this._data.length, mask.length);
        int b_size = 0;
        for (i = 0; i < a_size; ++i) {
            if (!mask[i]) continue;
            ++b_size;
        }
        int[] sub_data = new int[b_size];
        int index = 0;
        for (i = 0; i < a_size; ++i) {
            if (!mask[i]) continue;
            sub_data[index] = this._data[i];
        }
        return new IntArray(this.constrainer(), sub_data);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this._data.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this._data[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

