/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpConst;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.impl.ConstraintFloatExpLessValue;
import org.openl.ie.constrainer.impl.ConstraintFloatExpMoreValue;
import org.openl.ie.constrainer.impl.ExpressionImpl;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.FloatExpAddValue;
import org.openl.ie.constrainer.impl.IntBoolExpFloatEqExp;
import org.openl.ie.constrainer.impl.IntBoolExpFloatLessExp;

public abstract class FloatExpImpl
extends ExpressionImpl
implements FloatExp {
    public FloatExpImpl(Constrainer c) {
        this(c, "");
    }

    public FloatExpImpl(Constrainer c, String name) {
        super(c, name);
    }

    @Override
    public FloatExp add(double value) {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, this.max() + value);
        }
        return this.getFloatExp(FloatExpAddValue.class, (FloatExp)this, value);
    }

    @Override
    public boolean bound() {
        return FloatCalc.eq(this.min(), this.max());
    }

    @Override
    public String domainToString() {
        double max;
        double min = this.min();
        if (min == (max = this.max())) {
            return "[" + min + "]";
        }
        if (!this.bound()) {
            return "[" + min + ".." + max + "]";
        }
        return "[" + min + ".." + max + "(" + (min + max) / 2.0 + ")]";
    }

    @Override
    public IntBoolExp eq(double value) {
        return this.eq(this.getFloatExp(FloatExpConst.class, value));
    }

    @Override
    public IntBoolExp eq(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatEqExp.class, this, exp);
    }

    @Override
    public IntBoolExp eq(int value) {
        return this.eq((double)value);
    }

    @Override
    public IntBoolExp ge(double value) {
        return this.ge(this.getFloatExp(FloatExpConst.class, value));
    }

    @Override
    public IntBoolExp ge(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatLessExp.class, exp, this);
    }

    @Override
    public IntBoolExp ge(int value) {
        return this.ge((double)value);
    }

    @Override
    public IntBoolExp gt(double value) {
        return this.ge(value);
    }

    @Override
    public IntBoolExp gt(FloatExp exp) {
        return this.ge(exp);
    }

    @Override
    public IntBoolExp gt(int value) {
        return this.gt((double)value);
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    public IntBoolExp le(double value) {
        return this.le(this.getFloatExp(FloatExpConst.class, value));
    }

    @Override
    public IntBoolExp le(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatLessExp.class, this, exp);
    }

    @Override
    public IntBoolExp le(int value) {
        return this.le((double)value);
    }

    @Override
    public Constraint lessOrEqual(double value) {
        return new ConstraintFloatExpLessValue(this, value);
    }

    @Override
    public IntBoolExp lt(double value) {
        return this.le(value);
    }

    @Override
    public IntBoolExp lt(FloatExp exp) {
        return this.le(exp);
    }

    @Override
    public IntBoolExp lt(int value) {
        return this.lt((double)value);
    }

    @Override
    public FloatExp mod(double c) {
        throw new UnsupportedOperationException("mod");
    }

    @Override
    public FloatExp mod(int c) {
        throw new UnsupportedOperationException("mod");
    }

    @Override
    public Constraint moreOrEqual(double value) {
        return new ConstraintFloatExpMoreValue(this, value);
    }

    @Override
    public void propagate() throws Failure {
    }

    @Override
    public void removeRange(double min, double max) throws Failure {
        if (min < this.min()) {
            this.setMin(max);
        } else if (max > this.max()) {
            this.setMax(min);
        }
    }

    @Override
    public double size() {
        return this.max() - this.min();
    }

    @Override
    public String toString() {
        return this.name() + this.domainToString();
    }

    @Override
    public double value() throws Failure {
        return (this.min() + this.max()) / 2.0;
    }
}

