/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.constrainer.impl.IntVarImpl;

public final class IntExpAddArray1
extends IntExpImpl {
    private static final int[] event_map = new int[]{2, 2, 4, 4, 7, 1};
    private IntExpArray _vars;
    private Observer _observer;
    private IntVar _domainC;
    private DomainVar _domainE;

    public IntExpAddArray1(Constrainer constrainer, IntExpArray vars) {
        super(constrainer);
        int size = vars.size();
        this._vars = vars;
        this._observer = new ExpAddVectorObserver();
        IntExp[] data = this._vars.data();
        for (int i = 0; i < data.length; ++i) {
            data[i].attachObserver(this._observer);
        }
        String sum_name = "";
        if (this.constrainer().showInternalNames()) {
            StringBuilder s = new StringBuilder();
            s.append("(");
            for (int i = 0; i < data.length; ++i) {
                if (i != 0) {
                    s.append("+");
                }
                s.append(data[i].name());
            }
            s.append(")");
            this._name = s.toString();
            sum_name = "sum(" + this._vars.name() + ")";
        }
        int trace = 0;
        int min = this.calc_min();
        int max = this.calc_max();
        this._domainC = this.constrainer().addIntVarTraceInternal(min, max, sum_name, 0, trace);
        this._domainE = new DomainVar(this.constrainer(), min, max);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._domainC.attachObserver(observer);
    }

    int calc_max() {
        int max_sum = 0;
        IntExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            max_sum += vars[i].max();
        }
        return max_sum;
    }

    int calc_min() {
        int min_sum = 0;
        IntExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            min_sum += vars[i].min();
        }
        return min_sum;
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._domainC.detachObserver(observer);
    }

    void enforceDomainC() throws Failure {
        int minC = this._domainC.min();
        int maxC = this._domainC.max();
        int minE = this._domainE.min();
        int maxE = this._domainE.max();
        if (minC == minE && maxC == maxE) {
            return;
        }
        IntExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            int new_max;
            IntExp vari = vars[i];
            int mini = vari.min();
            int maxi = vari.max();
            int new_min = minC - (maxE - maxi);
            if (new_min > mini) {
                vari.setMin(new_min);
            }
            if ((new_max = maxC - (minE - mini)) >= maxi) continue;
            vari.setMax(new_max);
        }
    }

    @Override
    public boolean isLinear() {
        for (int i = 0; i < this._vars.size(); ++i) {
            if (this._vars.get(i).isLinear()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int max() {
        return this._domainC.max();
    }

    @Override
    public int min() {
        return this._domainC.min();
    }

    @Override
    public void name(String name) {
        super.name(name);
        this._domainC.name(name);
    }

    @Override
    public void onMaskChange() {
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._domainC.reattachObserver(observer);
    }

    @Override
    public void removeValue(int value) throws Failure {
        int Max = this._domainC.max();
        if (value > Max) {
            return;
        }
        int Min = this._domainC.min();
        if (value < Min) {
            return;
        }
        if (Min == Max) {
            this.constrainer().fail("remove for IntExpAddVector");
        }
        if (value == Max) {
            this.setMax(value - 1);
        }
        if (value == Min) {
            this.setMin(value + 1);
        }
    }

    @Override
    public void setMax(int max) throws Failure {
        if (max >= this._domainC.max()) {
            return;
        }
        this._domainC.setMax(max);
        int min_sum = this._domainE.min();
        IntExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            IntExp vari = vars[i];
            int maxi = max - (min_sum - vari.min());
            if (maxi >= vari.max()) continue;
            vari.setMax(maxi);
        }
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min <= this._domainC.min()) {
            return;
        }
        this._domainC.setMin(min);
        int max_sum = this._domainE.max();
        IntExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            IntExp vari = vars[i];
            int mini = min - (max_sum - vari.max());
            if (mini <= vari.min()) continue;
            vari.setMin(mini);
        }
    }

    @Override
    public void setValue(int value) throws Failure {
        if (this._domainC.min() == value && this._domainC.max() == value) {
            return;
        }
        this._domainC.setValue(value);
        int sum_min = this._domainE.min();
        int sum_max = this._domainE.max();
        IntExp[] vars = this._vars.data();
        for (int i = 0; i < vars.length; ++i) {
            int new_max;
            IntExp vari = vars[i];
            int mini = vari.min();
            int maxi = vari.max();
            int new_min = value - (sum_max - maxi);
            if (new_min > mini) {
                vari.setMin(new_min);
            }
            if ((new_max = value - (sum_min - mini)) >= maxi) continue;
            vari.setMax(new_max);
        }
    }

    @Override
    public int size() {
        return this.max() - this.min() + 1;
    }

    class ExpAddVectorObserver
    extends Observer {
        ExpAddVectorObserver() {
        }

        @Override
        public Object master() {
            return IntExpAddArray1.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpAddVectorObserver: " + IntExpAddArray1.this._vars;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            IntExpAddArray1.this._domainE.setMin(IntExpAddArray1.this._domainE.min() + e.mindiff());
            IntExpAddArray1.this._domainE.setMax(IntExpAddArray1.this._domainE.max() + e.maxdiff());
            IntExpAddArray1.this._domainC.setMin(IntExpAddArray1.this._domainE.min());
            IntExpAddArray1.this._domainC.setMax(IntExpAddArray1.this._domainE.max());
        }
    }

    final class DomainVar
    extends IntVarImpl {
        public DomainVar(Constrainer c, int min, int max) {
            super(c, min, max, "", 0);
        }

        @Override
        public void propagate() throws Failure {
            IntExpAddArray1.this.enforceDomainC();
        }
    }
}

