/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.Serializable;

public final class FastStack
implements Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 10;
    Object[] m_data;
    int m_size = 0;

    public FastStack() {
        this(10);
    }

    public FastStack(int capacity) {
        if (capacity == 0) {
            capacity = 10;
        }
        this.m_data = new Object[capacity];
    }

    public void clear() {
        this.m_size = 0;
        this.m_data = new Object[this.m_data.length];
    }

    public Object clone() {
        try {
            FastStack v = (FastStack)super.clone();
            v.m_data = (Object[])this.m_data.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final boolean empty() {
        return this.m_size == 0;
    }

    void grow() {
        Object[] old = this.m_data;
        this.m_data = new Object[this.m_data.length * 2];
        System.arraycopy(old, 0, this.m_data, 0, this.m_size);
    }

    public final Object peek() {
        return this.m_data[this.m_size - 1];
    }

    public final Object pop() {
        Object o = this.m_data[--this.m_size];
        this.m_data[this.m_size] = null;
        return o;
    }

    public final void push(Object obj) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_size++] = obj;
    }

    public void setSize(int newSize) {
        while (this.m_size > newSize) {
            this.m_data[--this.m_size] = null;
        }
    }

    public int size() {
        return this.m_size;
    }
}

