/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;

final class BitArray
implements Serializable {
    static final int BITS_PER_WORD = 32;
    int[] _bits;
    int _size;

    BitArray(int size) {
        this._bits = new int[(size - 1) / 32 + 1];
        this._size = size;
        for (int i = 0; i < this._bits.length; ++i) {
            this._bits[i] = -1;
        }
    }

    boolean at(int index) {
        return (this._bits[index / 32] & 1 << index) != 0;
    }

    void set(int index, boolean val) {
        if (val) {
            int n = index / 32;
            this._bits[n] = this._bits[n] | 1 << index;
        } else {
            int n = index / 32;
            this._bits[n] = this._bits[n] & ~(1 << index);
        }
    }

    void setBits(int[] bits) {
        this._bits = bits;
    }

    int size() {
        return this._size;
    }
}

