/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;

public final class ConstraintFloatExpLessExp
extends ConstraintImpl {
    private FloatExp _exp1;
    private FloatExp _exp2;
    private double _offset;
    private Constraint _opposite;

    public ConstraintFloatExpLessExp(FloatExp exp1, FloatExp exp2) {
        this(exp1, exp2, 0.0);
    }

    public ConstraintFloatExpLessExp(FloatExp exp1, FloatExp exp2, double offset) {
        super(exp1.constrainer(), "");
        this._name = "";
        if (this.constrainer().showInternalNames()) {
            this._name = exp1.name() + "<=" + exp2.name() + "+" + offset;
        }
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._offset = offset;
        this._opposite = null;
    }

    @Override
    public Goal execute() throws Failure {
        this._exp1.attachObserver(new ObserverExp1Min());
        this._exp2.attachObserver(new ObserverExp2Max());
        this._exp1.setMax(this._exp2.max() - this._offset);
        this._exp2.setMin(this._exp1.min() + this._offset);
        return null;
    }

    class ObserverExp2Max
    extends Observer {
        ObserverExp2Max() {
        }

        @Override
        public Object master() {
            return ConstraintFloatExpLessExp.this;
        }

        @Override
        public int subscriberMask() {
            return 4;
        }

        public String toString() {
            return ConstraintFloatExpLessExp.this._name + "(max:" + ConstraintFloatExpLessExp.this._exp2.name() + ")";
        }

        @Override
        public void update(Subject exp, EventOfInterest interest) throws Failure {
            ConstraintFloatExpLessExp.this._exp1.setMax(ConstraintFloatExpLessExp.this._exp2.max() - ConstraintFloatExpLessExp.this._offset);
        }
    }

    class ObserverExp1Min
    extends Observer {
        ObserverExp1Min() {
        }

        @Override
        public Object master() {
            return ConstraintFloatExpLessExp.this;
        }

        @Override
        public int subscriberMask() {
            return 2;
        }

        public String toString() {
            return ConstraintFloatExpLessExp.this._name + "(min:" + ConstraintFloatExpLessExp.this._exp1.name() + ")";
        }

        @Override
        public void update(Subject exp, EventOfInterest interest) throws Failure {
            ConstraintFloatExpLessExp.this._exp2.setMin(ConstraintFloatExpLessExp.this._exp1.min() + ConstraintFloatExpLessExp.this._offset);
        }
    }
}

