/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.Serializable;

public final class FastQueue
implements Serializable {
    static final int DEFAULT_CAPACITY = 10;
    static final int DEFAULT_FREE_SPACE_GROW_FACTOR = 10;
    int m_grow_factor = 10;
    Object[] m_data;
    int m_last = 0;
    int m_first = 0;

    public FastQueue() {
        this(10, 10);
    }

    public FastQueue(int capacity, int grow_factor) {
        if (capacity <= 0) {
            capacity = 10;
        }
        if (grow_factor == 0) {
            grow_factor = 10;
        }
        this.m_data = new Object[capacity];
    }

    public void clear() {
        this.m_first = 0;
        this.m_last = 0;
        this.m_data = new Object[this.m_data.length];
    }

    public Object clone() {
        try {
            FastQueue v = (FastQueue)super.clone();
            v.m_data = (Object[])this.m_data.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean empty() {
        return this.m_last == this.m_first;
    }

    void grow() {
        Object[] old_data = this.m_data;
        Object[] new_data = this.m_data;
        if (this.m_first < this.m_data.length * this.m_grow_factor / 100) {
            new_data = new Object[this.m_data.length * 2];
        }
        if (this.m_last > this.m_first) {
            System.arraycopy(old_data, this.m_first, new_data, 0, this.m_last - this.m_first);
        }
        this.m_data = new_data;
        this.m_last -= this.m_first;
        this.m_first = 0;
    }

    public Object peek() {
        return this.m_data[this.m_first];
    }

    public Object pop() {
        return this.m_data[this.m_first++];
    }

    public void push(Object obj) {
        if (this.m_last == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_last++] = obj;
    }

    public int size() {
        return this.m_last - this.m_first;
    }
}

