/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.Serializable;

public final class FastVectorDouble
implements Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 10;
    double[] m_data;
    int m_size = 0;

    public FastVectorDouble(int capacity) {
        if (capacity == 0) {
            capacity = 10;
        }
        this.m_data = new double[capacity];
    }

    public void add(double val) {
        if (this.m_size == this.m_data.length) {
            this.grow();
        }
        this.m_data[this.m_size++] = val;
    }

    public void clear() {
        this.m_size = 0;
    }

    public Object clone() {
        try {
            FastVectorDouble v = (FastVectorDouble)super.clone();
            v.m_data = (double[])this.m_data.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void cutSize(int new_size) {
        this.m_size = new_size;
    }

    public double elementAt(int i) {
        return this.m_data[i];
    }

    void grow() {
        double[] old = this.m_data;
        this.m_data = new double[this.m_data.length * 2];
        System.arraycopy(old, 0, this.m_data, 0, this.m_size);
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public double peek() {
        return this.m_data[this.m_size - 1];
    }

    public int size() {
        return this.m_size;
    }
}

