/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.openl.ie.tools.FastStack;
import org.openl.ie.tools.Reusable;

public abstract class ReusableFactory
implements Serializable {
    protected static Vector _allFactories = new Vector();
    protected FastStack _reusables = new FastStack();
    protected int _element_counter = 0;

    public static void cleanAll() {
        Enumeration it = _allFactories.elements();
        while (it.hasMoreElements()) {
            ((ReusableFactory)it.nextElement()).cleanUp();
        }
    }

    public static synchronized void printStatistics(PrintStream s) {
        s.println("Class,Count");
        for (int i = 0; i < _allFactories.size(); ++i) {
            ReusableFactory factory = (ReusableFactory)_allFactories.elementAt(i);
            s.println(factory.getClass() + "," + factory.getElementCount());
        }
    }

    public ReusableFactory() {
        this.register();
    }

    public void cleanUp() {
        this._reusables = new FastStack();
        this._element_counter = 0;
    }

    protected abstract Reusable createNewElement();

    public final synchronized void freeElement(Reusable element) {
        this._reusables.push(element);
    }

    public final synchronized Object getElement() {
        Reusable result;
        ++this._element_counter;
        if (this._reusables.empty()) {
            result = this.createNewElement();
            result.setFactory(this);
        } else {
            result = (Reusable)this._reusables.pop();
        }
        return result;
    }

    public int getElementCount() {
        return this._element_counter;
    }

    void register() {
        _allFactories.addElement(this);
    }
}

