/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintConst;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpConst
extends FloatExpImpl {
    private double _const;

    public FloatExpConst(Constrainer constrainer, double c) {
        super(constrainer, Double.toString(c));
        this._const = c;
    }

    @Override
    public FloatExp add(double value) {
        return this.getFloatExp(FloatExpConst.class, this._const + value);
    }

    @Override
    public boolean bound() {
        return true;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public Constraint lessOrEqual(double value) {
        return new ConstraintConst(this.constrainer(), this._const <= value);
    }

    @Override
    public double max() {
        return this._const;
    }

    @Override
    public double min() {
        return this._const;
    }

    @Override
    public Constraint moreOrEqual(double value) {
        return new ConstraintConst(this.constrainer(), this._const >= value);
    }

    @Override
    public void propagate() throws Failure {
    }

    @Override
    public void setMax(double max) throws Failure {
        if (max < this._const) {
            this.constrainer().fail("max<const");
        }
    }

    @Override
    public void setMin(double min) throws Failure {
        if (min > this._const) {
            this.constrainer().fail("min>const");
        }
    }

    @Override
    public void setValue(double value) throws Failure {
        if (value != this._const) {
            this.constrainer().fail("value!=const");
        }
    }

    @Override
    public String toString() {
        return "[" + this._const + "]";
    }

    @Override
    public double value() throws Failure {
        return this._const;
    }
}

