/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintConst;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.impl.ConstraintExpEqualsValue;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpConst
extends IntExpImpl {
    protected final int _const;

    public IntExpConst(Constrainer constrainer, int c) {
        super(constrainer);
        if (this.constrainer().showInternalNames()) {
            this._name = Integer.toString(c);
        }
        this._const = c;
    }

    @Override
    public final IntExp add(int value) {
        return this.getIntExp(IntExpConst.class, this._const + value);
    }

    @Override
    public final IntExp add(IntExp exp) {
        return exp.add(this._const);
    }

    @Override
    public final boolean bound() {
        return true;
    }

    @Override
    public final boolean contains(int value) {
        return value == this._const;
    }

    @Override
    public final Constraint equals(int value) {
        return new ConstraintConst(this.constrainer(), value == this._const);
    }

    @Override
    public final Constraint equals(IntExp exp) {
        return new ConstraintExpEqualsValue(exp, this._const);
    }

    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public final int max() {
        return this._const;
    }

    @Override
    public final int min() {
        return this._const;
    }

    @Override
    public final void propagate() throws Failure {
    }

    @Override
    public final void removeValue(int value) throws Failure {
        if (value == this._const) {
            this.constrainer().fail("remove const");
        }
    }

    @Override
    public final void setMax(int max) throws Failure {
        if (max < this._const) {
            this.constrainer().fail("max<const");
        }
    }

    @Override
    public final void setMin(int min) throws Failure {
        if (min > this._const) {
            this.constrainer().fail("min>const");
        }
    }

    @Override
    public final void setValue(int value) throws Failure {
        if (value != this._const) {
            this.constrainer().fail("value!=const");
        }
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final int value() {
        return this._const;
    }
}

