/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;

public final class ConstraintExpLessValue
extends ConstraintImpl {
    private IntExp _exp;
    private int _value;
    private Constraint _opposite;

    public ConstraintExpLessValue(IntExp exp, int value) {
        super(exp.constrainer());
        this._exp = exp;
        this._value = value;
        this._opposite = null;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "<" + value + ")";
        }
    }

    @Override
    public Goal execute() throws Failure {
        this._exp.setMax(this._value - 1);
        this._exp.attachObserver(new ObserverLessValue());
        return null;
    }

    public void resetValue(int v) {
        this._value = v;
    }

    @Override
    public String toString() {
        return this._exp + "<" + this._value;
    }

    class ObserverLessValue
    extends Observer {
        ObserverLessValue() {
        }

        @Override
        public Object master() {
            return ConstraintExpLessValue.this;
        }

        @Override
        public int subscriberMask() {
            return 3;
        }

        public String toString() {
            return "ObserverLessValue";
        }

        @Override
        public void update(Subject exp, EventOfInterest interest) throws Failure {
            IntEvent event = (IntEvent)interest;
            if (event.min() >= ConstraintExpLessValue.this._value) {
                exp.constrainer().fail("from ObserverLessValue");
            }
            ConstraintExpLessValue.this._exp.setMax(ConstraintExpLessValue.this._value - 1);
        }
    }
}

