/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Expression;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;

public abstract class ExpressionObserver
extends Observer {
    private static final int[] trival_event_map = new int[]{2, 2, 4, 4, 1, 1, 8, 8};
    private EventMap _event_map;
    private int _subscriber_mask;

    public ExpressionObserver() {
        this(trival_event_map);
    }

    public ExpressionObserver(int[] masks) {
        this._event_map = new EventMapImpl(masks);
    }

    public void publish(int publishMask, Expression exp) {
        this.subscriberMask(this._event_map.publishToSubscribe(publishMask), exp);
    }

    @Override
    public int subscriberMask() {
        return this._subscriber_mask;
    }

    @Override
    public void subscriberMask(int mask, Subject subj) {
        if (this._subscriber_mask != mask) {
            this._subscriber_mask = mask;
        }
        subj.reattachObserver(this);
    }

    public String toString() {
        return "ExpressionObserver";
    }

    public void transformMaxEvent(EventOfInterest event) throws Failure {
    }

    public void transformMinEvent(EventOfInterest event) throws Failure {
    }

    public void transformRemoveEvent(EventOfInterest event) throws Failure {
    }

    public void transformValueEvent(EventOfInterest event) throws Failure {
    }

    @Override
    public void update(Subject exp, EventOfInterest event) throws Failure {
        if (event.isValueEvent()) {
            this.transformValueEvent(event);
        } else if (event.isMinEvent()) {
            this.transformMinEvent(event);
        } else if (event.isMaxEvent()) {
            this.transformMaxEvent(event);
        } else if (event.isRemoveEvent()) {
            this.transformRemoveEvent(event);
        }
    }

    class EventMapImpl
    implements EventMap {
        private int[] _masks;

        EventMapImpl(int[] masks) {
            this._masks = masks;
        }

        @Override
        public int publishToSubscribe(int publish_mask) {
            int result_mask = 0;
            for (int i = 0; i < this._masks.length; i += 2) {
                if ((this._masks[i + 1] & publish_mask) == 0) continue;
                result_mask |= this._masks[i];
            }
            return result_mask;
        }
    }

    static interface EventMap
    extends Serializable {
        public int publishToSubscribe(int var1);
    }
}

