/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatDomain;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalFloatInstantiate;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.impl.FloatDomainHistory;
import org.openl.ie.constrainer.impl.FloatDomainImpl;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.constrainer.impl.SubjectImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public class FloatVarImpl
extends FloatExpImpl
implements FloatVar {
    private FloatDomain _domain;
    private FloatDomainHistory _history;

    public FloatVarImpl(Constrainer constrainer, double min, double max, String name) {
        super(constrainer, name);
        this._domain = new FloatDomainImpl(this, min, max);
        this._history = new FloatDomainHistory(this);
    }

    @Override
    public Undo createUndo() {
        this._history.saveUndo();
        return UndoFloatVar.getFloatVarUndo();
    }

    @Override
    public void forceMax(double max) {
        this._domain.forceMax(max);
    }

    @Override
    public void forceMin(double min) {
        this._domain.forceMin(min);
    }

    public FloatDomainHistory history() {
        return this._history;
    }

    @Override
    public Goal instantiate() {
        return new GoalFloatInstantiate(this);
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public double max() {
        return this._domain.max();
    }

    @Override
    public double min() {
        return this._domain.min();
    }

    @Override
    public void propagate() throws Failure {
        this._history.propagate();
    }

    @Override
    public void setMax(double max) throws Failure {
        if (this._domain.setMax(max)) {
            this._history.setMax(max);
            this.addToPropagationQueue();
        }
    }

    @Override
    public void setMin(double min) throws Failure {
        if (this._domain.setMin(min)) {
            this._history.setMin(min);
            this.addToPropagationQueue();
        }
    }

    @Override
    public void setValue(double value) throws Failure {
        if (this._domain.setValue(value)) {
            this._history.setMin(value);
            this._history.setMax(value);
            this.addToPropagationQueue();
        }
    }

    @Override
    public double size() {
        return this._domain.size();
    }

    @Override
    public double value() throws Failure {
        if (!this.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound float expresion " + this);
        }
        return (this.min() + this.max()) / 2.0;
    }

    static class UndoFloatVar
    extends SubjectImpl.UndoSubject {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoFloatVar();
            }
        };
        private int _history_index;

        UndoFloatVar() {
        }

        static UndoFloatVar getFloatVarUndo() {
            return (UndoFloatVar)_factory.getElement();
        }

        @Override
        public String toString() {
            return "UndoFloatVar " + this.undoable();
        }

        @Override
        public void undo() {
            FloatVarImpl floatvar = (FloatVarImpl)this.undoable();
            floatvar.history().restore(this._history_index);
            super.undo();
        }

        @Override
        public void undoable(Undoable u) {
            super.undoable(u);
            FloatVarImpl floatvar = (FloatVarImpl)u;
            this._history_index = floatvar.history().currentIndex();
        }
    }
}

