/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntExpAddExp
extends IntExpImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private Observer _observer;
    private IntVar _sum;

    public IntExpAddExp(IntExp exp1, IntExp exp2) {
        super(exp1.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp1.name() + "+" + exp2.name() + ")";
        }
        this._exp1 = exp1;
        this._exp2 = exp2;
        int trace = 0;
        this._sum = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), this._name, 0, trace);
        this._observer = new ExpAddExpObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._sum.attachObserver(observer);
    }

    public int calc_max() {
        return this._exp1.max() + this._exp2.max();
    }

    public int calc_min() {
        return this._exp1.min() + this._exp2.min();
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._sum.detachObserver(observer);
    }

    @Override
    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    @Override
    public int max() {
        return this._sum.max();
    }

    @Override
    public int min() {
        return this._sum.min();
    }

    @Override
    public void onMaskChange() {
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._sum.reattachObserver(observer);
    }

    @Override
    public void removeValue(int value) throws Failure {
        int Max = this.max();
        if (value > Max) {
            return;
        }
        int Min = this.min();
        if (value < Min) {
            return;
        }
        if (Min == Max) {
            this.constrainer().fail("remove for IntExpAddExp");
        }
        if (value == Max) {
            this.setMax(value - 1);
        }
        if (value == Min) {
            this.setMin(value + 1);
        }
    }

    @Override
    public void setMax(int max) throws Failure {
        int max2;
        if (max >= this._sum.max()) {
            return;
        }
        int max1 = max - this._exp2.min();
        if (max1 < this._exp1.max()) {
            this._exp1.setMax(max1);
        }
        if ((max2 = max - this._exp1.min()) < this._exp2.max()) {
            this._exp2.setMax(max2);
        }
    }

    @Override
    public void setMin(int min) throws Failure {
        int min2;
        if (min <= this._sum.min()) {
            return;
        }
        int min1 = min - this._exp2.max();
        if (min1 > this._exp1.min()) {
            this._exp1.setMin(min1);
        }
        if ((min2 = min - this._exp1.max()) > this._exp2.min()) {
            this._exp2.setMin(min2);
        }
    }

    @Override
    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    static final class IntEventAddExp
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new IntEventAddExp();
            }
        };
        int _type;
        IntExp _second;
        IntEvent _event;

        IntEventAddExp() {
        }

        static IntEventAddExp getEvent(IntEvent event, IntExp exp) {
            IntEventAddExp ev = (IntEventAddExp)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        public void init(IntEvent e, IntExp second) {
            this._event = e;
            this._second = second;
            this._type = e.type();
            if (!this._second.bound()) {
                this._type &= 0xFFFFFFF6;
            }
        }

        @Override
        public int max() {
            return this._event.max() + this._second.max();
        }

        @Override
        public int min() {
            return this._event.min() + this._second.min();
        }

        @Override
        public String name() {
            return "Event AddExp";
        }

        @Override
        public int numberOfRemoves() {
            if ((this._type & 8) != 0) {
                return this._event.numberOfRemoves();
            }
            return 0;
        }

        @Override
        public int oldmax() {
            return this._event.oldmax() + this._second.max();
        }

        @Override
        public int oldmin() {
            return this._event.oldmin() + this._second.min();
        }

        @Override
        public int removed(int i) {
            return this._event.removed(i) + this._second.min();
        }

        @Override
        public int type() {
            return this._type;
        }
    }

    class ExpAddExpObserver
    extends Observer {
        ExpAddExpObserver() {
        }

        @Override
        public Object master() {
            return IntExpAddExp.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpAddExpObserver: ";
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntExpAddExp.this._sum.setMin(IntExpAddExp.this.calc_min());
            IntExpAddExp.this._sum.setMax(IntExpAddExp.this.calc_max());
        }
    }
}

