/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntCalc;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntExpEnum
extends IntExpImpl {
    private int[] _values;
    protected IntVar _index;
    private ExpressionObserver _observer;

    public IntExpEnum(Constrainer c, int[] values, String name) {
        super(c, name);
        this.init(values);
    }

    @Override
    public boolean contains(int value) {
        int idx = this.valueIndex(value, this._index.min(), this._index.max());
        return idx >= 0 && this._index.contains(idx);
    }

    @Override
    public String domainToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int min = this._index.min();
        int max = this._index.max();
        for (int i = min; i <= max; ++i) {
            if (!this._index.contains(i)) continue;
            if (i != min) {
                buf.append(" ");
            }
            buf.append(String.valueOf(this._values[i]));
        }
        buf.append("]");
        return buf.toString();
    }

    void init(int[] values) {
        this._values = IntCalc.differentSortedValues(values);
        int trace = 0;
        int type = 1;
        String indexName = "";
        if (this.constrainer().showInternalNames()) {
            indexName = "index_" + this.name();
        }
        int indexMax = this._values.length - 1;
        this._index = this.constrainer().addIntVarTraceInternal(0, indexMax, indexName, type, trace);
        this._observer = new IndexObserver();
        this._index.attachObserver(this._observer);
    }

    @Override
    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        this.iterateDomain2(it);
    }

    void iterateDomain2(IntExp.IntDomainIterator it) throws Failure {
        int min = this._index.min();
        int max = this._index.max();
        for (int idx = min; idx <= max; ++idx) {
            if (!this._index.contains(idx) || it.doSomethingOrStop(this._values[idx])) continue;
            return;
        }
    }

    @Override
    public int max() {
        return this._values[this._index.max()];
    }

    @Override
    public int min() {
        return this._values[this._index.min()];
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._index);
    }

    @Override
    public void removeValue(int value) throws Failure {
        int idx = this.valueIndex(value, this._index.min(), this._index.max());
        if (idx >= 0) {
            this._index.removeValue(idx);
        }
    }

    @Override
    public void setMax(int M) throws Failure {
        int idx;
        if (M >= this.max()) {
            return;
        }
        if (M < this.min()) {
            this.constrainer().fail("Max < Min ");
        }
        if ((idx = IntCalc.binarySearch(this._values, M)) >= 0) {
            this._index.setMax(idx);
        } else {
            int insertion_point = -(idx + 1);
            this._index.setMax(insertion_point - 1);
        }
    }

    @Override
    public void setMin(int m) throws Failure {
        int idx;
        if (m <= this.min()) {
            return;
        }
        if (m > this.max()) {
            this.constrainer().fail("Min > Max");
        }
        if ((idx = IntCalc.binarySearch(this._values, m)) >= 0) {
            this._index.setMin(idx);
        } else {
            int insertion_point = -(idx + 1);
            this._index.setMin(insertion_point);
        }
    }

    @Override
    public void setValue(int value) throws Failure {
        int idx = this.valueIndex(value, this._index.min(), this._index.max());
        if (idx >= 0) {
            this._index.setValue(idx);
        } else {
            this.constrainer().fail("IntExpEnum.setValue()");
        }
    }

    @Override
    public int size() {
        return this._index.size();
    }

    int valueIndex(int value, int minIndex, int maxIndex) {
        int index = IntCalc.binarySearch(this._values, value);
        if (minIndex <= index && index <= maxIndex) {
            return index;
        }
        return -1;
    }

    static class IntEventEnum
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new IntEventEnum();
            }
        };
        int[] _values;
        IntEvent _event;

        IntEventEnum() {
        }

        static IntEventEnum getEvent(IntEvent event, int[] values) {
            IntEventEnum ev = (IntEventEnum)_factory.getElement();
            ev.init(event, values);
            return ev;
        }

        public void init(IntEvent e, int[] values) {
            this._event = e;
            this._values = values;
        }

        @Override
        public int max() {
            return this._values[this._event.max()];
        }

        @Override
        public int min() {
            return this._values[this._event.min()];
        }

        @Override
        public String name() {
            return "IntEventEnum";
        }

        @Override
        public int numberOfRemoves() {
            return this._event.numberOfRemoves();
        }

        @Override
        public int oldmax() {
            return this._values[this._event.oldmax()];
        }

        @Override
        public int oldmin() {
            return this._values[this._event.oldmin()];
        }

        @Override
        public int removed(int i) {
            return this._values[this._event.removed(i)];
        }

        @Override
        public int type() {
            return this._event.type();
        }
    }

    class IndexObserver
    extends ExpressionObserver {
        IndexObserver() {
        }

        @Override
        public Object master() {
            return IntExpEnum.this;
        }

        @Override
        public String toString() {
            return "IndexObserver:" + IntExpEnum.this._index;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            IntEventEnum ev = IntEventEnum.getEvent(e, IntExpEnum.this._values);
            IntExpEnum.this.notifyObservers(ev);
        }
    }
}

