/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTExceptionWrapper
extends RuntimeException {
    Throwable _t;

    public static RuntimeException wrap(String s, Throwable t) {
        return RTExceptionWrapper.wrap(s, t, false);
    }

    public static RuntimeException wrap(String s, Throwable t, boolean always) {
        if (t instanceof RuntimeException && (s == null || s.length() == 0) && !always) {
            return (RuntimeException)t;
        }
        return new RTExceptionWrapper(s, t);
    }

    public RTExceptionWrapper(String s, Throwable t) {
        super(s);
        this._t = t;
    }

    @Override
    public String getMessage() {
        String errMsg = super.getMessage();
        if (this._t != null && (errMsg == null || errMsg.equals(""))) {
            String subMess = this._t.getMessage();
            if (subMess != null && subMess.length() > 0) {
                return subMess;
            }
            return this._t.getClass().getName();
        }
        return errMsg;
    }

    @Override
    public void printStackTrace() {
        Logger log = LoggerFactory.getLogger(RTExceptionWrapper.class);
        log.error(this.getMessage(), this._t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this.getMessage());
            this._t.printStackTrace(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this.getMessage());
            this._t.printStackTrace(s);
        }
    }
}

