/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.consistencyChecking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalGenerate;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntBoolExpConst;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.consistencyChecking.CDecisionTable;
import org.openl.ie.constrainer.consistencyChecking.CompletenessChecker;
import org.openl.ie.constrainer.consistencyChecking.DTChecker;
import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.ie.constrainer.consistencyChecking.OverlappingChecker;
import org.openl.ie.constrainer.consistencyChecking.OverlappingCheckerImpl2;
import org.openl.ie.constrainer.consistencyChecking.Uncovered;

public class DTCheckerImpl
implements DTChecker {
    private CDecisionTable _dt;
    private final CompletenessChecker _cpChecker = new CompletenessCheckerImpl();
    private final OverlappingChecker _opChecker;
    private final List<Uncovered> _uncoveredRegions = new ArrayList<Uncovered>();

    public DTCheckerImpl(CDecisionTable dtable) {
        this._dt = dtable;
        this._opChecker = new OverlappingCheckerImpl2(this._dt);
    }

    @Override
    public List<Uncovered> checkCompleteness() {
        return this._cpChecker.check();
    }

    @Override
    public List<Overlapping> checkOverlappings() {
        return this._opChecker.check();
    }

    @Override
    public CDecisionTable getDT() {
        return this._dt;
    }

    @Override
    public void setDT(CDecisionTable dtable) {
        this._dt = dtable;
    }

    private class CompletenessCheckerImpl
    implements CompletenessChecker {
        private CompletenessCheckerImpl() {
        }

        @Override
        public List<Uncovered> check() {
            IntBoolExp[] rules = DTCheckerImpl.this._dt.getRules();
            Constrainer c = rules[0].constrainer();
            int stackSize = c.getStackSize();
            IntExpArray ruleArray = new IntExpArray(c, rules.length);
            for (int i = 0; i < rules.length; ++i) {
                ruleArray.set(rules[i], i);
            }
            Constraint incompleteness = ruleArray.sum().equals(0);
            GoalSaveSolutions save = new GoalSaveSolutions(c);
            GoalGenerate generate = new GoalGenerate(DTCheckerImpl.this._dt.getVars());
            GoalAnd target = new GoalAnd(new GoalAnd(incompleteness, generate), save);
            c.execute(target, true);
            c.backtrackStack(stackSize);
            return DTCheckerImpl.this._uncoveredRegions;
        }

        private class GoalSaveSolutions
        extends GoalImpl {
            private static final long serialVersionUID = -4747909482843265994L;

            public GoalSaveSolutions(Constrainer c) {
                super(c);
            }

            @Override
            public Goal execute() throws Failure {
                DTCheckerImpl.this._uncoveredRegions.add(new Uncovered(DTCheckerImpl.this._dt.getVars()));
                return null;
            }
        }
    }

    public static class CDecisionTableImpl
    implements CDecisionTable {
        private final IntBoolExp[] _rules;
        private final IntExpArray _vars;
        private final boolean overrideAscending;

        public CDecisionTableImpl(IntBoolExp[][] data, IntExpArray vars, boolean overrideAscending) {
            if (data == null) {
                throw new IllegalArgumentException("DecisionTableImpl(IntBoolExp[][] _data, IntExpArray vars) : cannot be created based on null data array.");
            }
            this._vars = vars;
            this.overrideAscending = overrideAscending;
            int nbRules = data.length;
            this._rules = new IntBoolExp[nbRules];
            Arrays.fill(this._rules, new IntBoolExpConst(this._vars.constrainer(), true));
            for (int i = 0; i < data.length; ++i) {
                int nbVars = data[i].length;
                for (int j = 0; j < nbVars; ++j) {
                    this._rules[i] = this._rules[i].and(data[i][j]);
                }
            }
        }

        @Override
        public IntBoolExp getRule(int i) {
            return this._rules[i];
        }

        @Override
        public IntBoolExp[] getRules() {
            return this._rules;
        }

        @Override
        public IntVar getVar(int i) {
            return (IntVar)this._vars.get(i);
        }

        @Override
        public IntExpArray getVars() {
            return this._vars;
        }

        @Override
        public boolean isOverrideAscending() {
            return this.overrideAscending;
        }
    }
}

