/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.impl.BitArray;
import org.openl.ie.constrainer.impl.DomainImpl;

public final class DomainBits2
extends DomainImpl {
    private int _size;
    final BitArray _bits;

    public DomainBits2(IntVar var, int min, int max) {
        super(var, min, max);
        this._size = this._max - this._min + 1;
        this._bits = new BitArray(this._size);
    }

    public int[] bits() {
        return this._bits._bits;
    }

    @Override
    public boolean contains(int value) {
        if (value < this._min || value > this._max) {
            return false;
        }
        return this._bits.at(value - this._initial_min);
    }

    public void forceBits(int[] bits) {
        this._bits._bits = bits;
    }

    @Override
    public void forceInsert(int val) {
        this._bits.set(val - this._initial_min, true);
    }

    @Override
    public void forceSize(int size) {
        this._size = size;
    }

    @Override
    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        for (int i = this._min - this._initial_min; i <= this._max - this._initial_min; ++i) {
            if (!this._bits.at(i) || it.doSomethingOrStop(i + this._initial_min)) continue;
            return;
        }
    }

    @Override
    public int max() {
        return this._max;
    }

    @Override
    public int min() {
        return this._min;
    }

    @Override
    public boolean removeRange(int min, int max) throws Failure {
        if (min <= this._min && max >= this._max) {
            this.constrainer().fail("Empty domain");
        }
        if (min <= this._min && max >= this._min) {
            return this.setMin(max + 1);
        }
        if (max >= this._max && min <= this._max) {
            return this.setMax(min - 1);
        }
        boolean is_removed = false;
        for (int i = min; i <= max; ++i) {
            if (!this.contains(i)) continue;
            this._variable.addUndo();
            this._bits.set(i - this._initial_min, false);
            --this._size;
            is_removed = true;
        }
        return is_removed;
    }

    @Override
    public boolean removeValue(int value) throws Failure {
        if (!this.contains(value)) {
            return false;
        }
        if (value == this._min) {
            return this.setMin(value + 1);
        }
        if (value == this._max) {
            return this.setMax(value - 1);
        }
        this._variable.addUndo();
        this._bits.set(value - this._initial_min, false);
        --this._size;
        return true;
    }

    @Override
    public boolean setMax(int M) throws Failure {
        if (M >= this._max) {
            return false;
        }
        if (M < this._min) {
            this.constrainer().fail("Max < Min");
        }
        this._variable.addUndo();
        while (this._max > M) {
            if (!this._bits.at(this._max-- - this._initial_min)) continue;
            --this._size;
        }
        for (int i = this._max - this._initial_min; i >= 0 && !this._bits.at(i); --i) {
            if (--this._max >= this._min) continue;
            this.constrainer().fail("max");
        }
        return true;
    }

    @Override
    public boolean setMin(int m) throws Failure {
        if (m <= this._min) {
            return false;
        }
        if (m > this._max) {
            this.constrainer().fail("Min > Max");
        }
        this._variable.addUndo();
        while (this._min < m) {
            if (!this._bits.at(this._min++ - this._initial_min)) continue;
            --this._size;
        }
        for (int i = this._min - this._initial_min; i < this._bits.size() && !this._bits.at(i); ++i) {
            if (++this._min <= this._max) continue;
            this.constrainer().fail("min");
        }
        return true;
    }

    @Override
    public boolean setValue(int value) throws Failure {
        if (this._min == value && this._max == value) {
            return false;
        }
        if (!this.contains(value)) {
            this.constrainer().fail("attempt to set invalid value");
        }
        this._variable.addUndo();
        this._min = value;
        this._max = value;
        this._size = 1;
        return true;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int type() {
        return 2;
    }
}

