/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Expression;
import org.openl.ie.constrainer.ExpressionFactory;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.UndoImpl;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.impl.UndoableOnceImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class ExpressionFactoryImpl
extends UndoableOnceImpl
implements ExpressionFactory,
Serializable {
    private static final long serialVersionUID = 7593413055525940597L;
    private Hashtable _expressions = new Hashtable();
    private boolean _getFromCache = false;
    private boolean _putInCache = false;
    private boolean _useCache = false;

    static Class[] args2types(Object[] args) {
        int size = args.length;
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            types[i] = args[i].getClass();
        }
        return types;
    }

    public ExpressionFactoryImpl(Constrainer constrainer) {
        super(constrainer, ExpressionFactoryImpl.class.getName());
    }

    Expression createExpression(Class c, Object[] args, Class[] types) {
        try {
            Constructor constr = c.getConstructor(types);
            constr.setAccessible(true);
            return (Expression)constr.newInstance(args);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            String msg = "Error creating expression: " + e.getClass().getName() + ": " + e.getMessage() + ": " + c.getName();
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public Undo createUndo() {
        return UndoExpressionFactory.getUndo();
    }

    Expression findExpression(ExpressionKey key) {
        return (Expression)this._expressions.get(key);
    }

    @Override
    public Expression getExpression(Class clazz, Object[] args) {
        return this.getExpression(clazz, args, ExpressionFactoryImpl.args2types(args));
    }

    @Override
    public Expression getExpression(Class clazz, Object[] args, Class[] types) {
        Expression exp;
        ExpressionKeyImpl key = this._getFromCache || this._putInCache ? new ExpressionKeyImpl(clazz, args) : null;
        Expression expression = exp = this._getFromCache ? this.findExpression(key) : null;
        if (exp == null) {
            exp = this.createExpression(clazz, args, types);
            if (this._putInCache) {
                this.addUndo();
                this._expressions.put(key, exp);
            }
        }
        return exp;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        Enumeration e = this._expressions.keys();
        while (e.hasMoreElements()) {
            ExpressionKey key = (ExpressionKey)e.nextElement();
            Expression exp = (Expression)this._expressions.get(key);
            s.append(exp.getClass().getName()).append(", ").append(System.identityHashCode(exp)).append(", ");
            for (int i = 0; i < key.args().length; ++i) {
                Object o;
                if (i != 0) {
                    s.append(", ");
                }
                if ((o = key.args()[i]) instanceof Number) {
                    s.append(o.getClass().getName()).append(", ").append(o);
                    continue;
                }
                s.append(o.getClass().getName()).append(", ").append(System.identityHashCode(o));
            }
            s.append('\n');
        }
        return s.toString();
    }

    static class UndoExpressionFactory
    extends UndoImpl {
        static final ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoExpressionFactory();
            }
        };
        private Hashtable _expressions;

        UndoExpressionFactory() {
        }

        static UndoExpressionFactory getUndo() {
            return (UndoExpressionFactory)_factory.getElement();
        }

        @Override
        public String toString() {
            return "UndoExpressionFactory " + this.undoable();
        }

        @Override
        public void undo() {
            ExpressionFactoryImpl expFactory = (ExpressionFactoryImpl)this.undoable();
            expFactory._expressions = this._expressions;
            super.undo();
        }

        @Override
        public void undoable(Undoable u) {
            super.undoable(u);
            ExpressionFactoryImpl expFactory = (ExpressionFactoryImpl)u;
            this._expressions = (Hashtable)expFactory._expressions.clone();
        }
    }

    static class ExpressionKeyImpl
    implements ExpressionKey {
        private final Class _clazz;
        private final Object[] _args;

        static boolean equalArgs(Object arg1, Object arg2) {
            if (arg1 == arg2) {
                return true;
            }
            if (arg1.getClass() != arg2.getClass()) {
                return false;
            }
            if (arg1 instanceof Number) {
                return arg1.equals(arg2);
            }
            if (arg1 instanceof IntExpArray) {
                return ExpressionKeyImpl.equalArrays((IntExpArray)arg1, (IntExpArray)arg2);
            }
            return false;
        }

        static boolean equalArrays(IntExpArray arg1, IntExpArray arg2) {
            return ExpressionKeyImpl.equalArrays(arg1.data(), arg2.data());
        }

        static boolean equalArrays(Object[] arg1, Object[] arg2) {
            int size = arg1.length;
            if (size != arg2.length) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (ExpressionKeyImpl.equalArgs(arg1[i], arg2[i])) continue;
                return false;
            }
            return true;
        }

        public ExpressionKeyImpl(Class clazz, Object[] args) {
            this._clazz = clazz;
            this._args = args;
        }

        @Override
        public Object[] args() {
            return this._args;
        }

        @Override
        public Class clazz() {
            return this._clazz;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExpressionKey)) {
                return false;
            }
            ExpressionKey key = (ExpressionKey)o;
            if (this._clazz != key.clazz()) {
                return false;
            }
            if (this._args.length != key.args().length) {
                return false;
            }
            for (int i = 0; i < this._args.length; ++i) {
                if (ExpressionKeyImpl.equalArgs(this._args[i], key.args()[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this._clazz.hashCode() + this._args.length;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("class: ").append(this._clazz.getName()).append(", args:(");
            for (int i = 0; i < this._args.length; ++i) {
                if (i != 0) {
                    s.append(",");
                }
                s.append(this._args[i]);
            }
            s.append(")");
            return s.toString();
        }
    }

    static interface ExpressionKey {
        public Object[] args();

        public Class clazz();
    }
}

