/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Domain;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.impl.DomainBits;
import org.openl.ie.constrainer.impl.DomainBits2;
import org.openl.ie.constrainer.impl.DomainImpl;
import org.openl.ie.constrainer.impl.IntDomainHistory;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.constrainer.impl.SubjectImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public class IntVarImpl
extends IntExpImpl
implements IntVar {
    private Domain _domain;
    private final IntDomainHistory _history;

    public IntVarImpl(Constrainer constrainer, int min, int max, String name, int domain_type) {
        super(constrainer, name);
        int size = max - min + 1;
        switch (domain_type) {
            case 0: {
                this._domain = new DomainImpl(this, min, max);
                break;
            }
            case 1: {
                this._domain = new DomainBits(this, min, max);
                break;
            }
            case 2: {
                this._domain = new DomainBits2(this, min, max);
                break;
            }
            case -1: {
                this._domain = size < 16 ? new DomainBits(this, min, max) : (size < 128 ? new DomainBits2(this, min, max) : new DomainImpl(this, min, max));
            }
        }
        this._history = new IntDomainHistory(this);
    }

    @Override
    public boolean contains(int value) {
        return this._domain.contains(value);
    }

    @Override
    public Undo createUndo() {
        this._history.saveUndo();
        return UndoIntVarImpl.getIntVarUndo();
    }

    @Override
    public String domainToString() {
        return this._domain.toString();
    }

    @Override
    public int domainType() {
        return this._domain.type();
    }

    @Override
    public void forceInsert(int val) {
        this._domain.forceInsert(val);
    }

    @Override
    public void forceMax(int val) {
        this._domain.forceMax(val);
    }

    @Override
    public void forceMin(int val) {
        this._domain.forceMin(val);
    }

    @Override
    public void forceSize(int val) {
        this._domain.forceSize(val);
    }

    public IntDomainHistory history() {
        return this._history;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        this._domain.iterateDomain(it);
    }

    @Override
    public int max() {
        return this._domain.max();
    }

    @Override
    public int min() {
        return this._domain.min();
    }

    @Override
    public void propagate() throws Failure {
        this._history.propagate();
    }

    @Override
    protected void removeRangeInternal(int min, int max) throws Failure {
        if (this._domain.removeRange(min, max)) {
            this._history.setMin(this._domain.min());
            this._history.setMax(this._domain.max());
            this._history.remove(min, max);
            this.addToPropagationQueue();
        }
    }

    @Override
    public void removeValue(int value) throws Failure {
        if (this._domain.removeValue(value)) {
            this._history.setMin(this._domain.min());
            this._history.setMax(this._domain.max());
            this._history.remove(value);
            this.addToPropagationQueue();
        }
    }

    @Override
    public void setMax(int max) throws Failure {
        if (this._domain.setMax(max)) {
            this._history.setMax(this.max());
            this.addToPropagationQueue();
        }
    }

    @Override
    public void setMin(int min) throws Failure {
        if (this._domain.setMin(min)) {
            this._history.setMin(this.min());
            this.addToPropagationQueue();
        }
    }

    @Override
    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public int size() {
        return this._domain.size();
    }

    @Override
    public int value() throws Failure {
        if (!this.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound variable " + this);
        }
        return this._domain.min();
    }

    static final class UndoIntVarImpl
    extends SubjectImpl.UndoSubject {
        static final ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoIntVarImpl();
            }
        };
        int _history_index;

        UndoIntVarImpl() {
        }

        static UndoIntVarImpl getIntVarUndo() {
            return (UndoIntVarImpl)_factory.getElement();
        }

        @Override
        public String toString() {
            return "UndoIntVar " + this.undoable();
        }

        @Override
        public void undo() {
            IntVarImpl intvar = (IntVarImpl)this.undoable();
            intvar.history().restore(this._history_index);
            super.undo();
        }

        @Override
        public void undoable(Undoable u) {
            super.undoable(u);
            IntVarImpl intvar = (IntVarImpl)u;
            this._history_index = intvar.history().currentIndex();
        }
    }
}

