/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Collection;
import java.util.HashSet;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.UndoImpl;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.impl.UndoableOnceImpl;
import org.openl.ie.tools.FastVector;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public abstract class SubjectImpl
extends UndoableOnceImpl
implements Subject {
    protected final FastVector _observers;
    protected boolean _in_process;
    protected int _publisher_mask;

    public SubjectImpl(Constrainer constrainer) {
        this(constrainer, "");
    }

    public SubjectImpl(Constrainer constrainer, String name) {
        super(constrainer, name);
        if (constrainer.showVariableNames()) {
            this._name = name;
        }
        this._observers = new FastVector();
        this._in_process = false;
    }

    public void addToPropagationQueue() {
        if (!this._in_process) {
            this.constrainer().addToPropagationQueue(this);
            this._in_process = true;
        }
    }

    @Override
    public Collection allDependents() {
        HashSet<Object> dependendts = new HashSet<Object>();
        for (int i = 0; i < this._observers.size(); ++i) {
            Observer obs = (Observer)this._observers.elementAt(i);
            Object master = obs.master();
            if (master == null || dependendts.contains(master)) continue;
            dependendts.add(master);
            if (!(master instanceof Subject)) continue;
            dependendts.addAll(((Subject)master).allDependents());
        }
        return dependendts;
    }

    @Override
    public void attachObserver(Observer observer) {
        this._observers.addElement(observer);
        this.publisherMask(this._publisher_mask | observer.subscriberMask());
        this.constrainer().addUndo(UndoAttachObserver.getUndo(this, observer));
    }

    @Override
    public Undo createUndo() {
        return UndoSubject.getUndo();
    }

    @Override
    public void detachObserver(Observer observer) {
        this._observers.removeElement(observer);
        this.constrainer().addUndo(UndoDetachObserver.getUndo(this, observer));
    }

    @Override
    public void forcedAttachObserver(Observer observer) {
        this._observers.addElement(observer);
    }

    @Override
    public void forcedDetachObserver(Observer observer) {
        this._observers.removeElement(observer);
    }

    @Override
    public void forcePublisherMask(int mask) {
        this._publisher_mask = mask;
    }

    @Override
    public void inProcess(boolean flag) {
        this._in_process = flag;
    }

    @Override
    public final void notifyObservers(EventOfInterest interest) throws Failure {
        FastVector observers = this._observers;
        this._constrainer.incrementNumberOfNotifications();
        int size = observers.size();
        for (int i = 0; i < size; ++i) {
            Observer observer = (Observer)observers.elementAt(i);
            if (!observer.interestedIn(interest)) continue;
            observer.update(this, interest);
        }
        interest.free();
    }

    public void onMaskChange() {
    }

    @Override
    public abstract void propagate() throws Failure;

    @Override
    public void publish(int mask) {
        this.publisherMask(this._publisher_mask | mask);
    }

    @Override
    public int publisherMask() {
        return this._publisher_mask;
    }

    @Override
    public void publisherMask(int mask) {
        if (mask != this._publisher_mask) {
            this._publisher_mask = mask;
            this.onMaskChange();
            this.addUndo();
        }
    }

    @Override
    public void reattachObserver(Observer observer) {
        this.publisherMask(this._publisher_mask | observer.subscriberMask());
    }

    @Override
    public void trace() {
        class ObserverTraceAll
        extends Observer {
            ObserverTraceAll() {
            }

            @Override
            public Object master() {
                return null;
            }

            @Override
            public int subscriberMask() {
                return 15;
            }

            @Override
            public void update(Subject var, EventOfInterest interest) throws Failure {
                System.out.println("Trace " + interest + ": " + var);
            }
        }
        this.attachObserver(new ObserverTraceAll());
    }

    @Override
    public void trace(int event_type) {
        class ObserverTrace
        extends Observer {
            private final int _event_type;

            ObserverTrace(int event_type) {
                this._event_type = event_type;
            }

            @Override
            public Object master() {
                return null;
            }

            @Override
            public int subscriberMask() {
                return this._event_type;
            }

            @Override
            public void update(Subject var, EventOfInterest interest) throws Failure {
                System.out.println("Trace " + interest + ": " + var);
            }
        }
        this.attachObserver(new ObserverTrace(event_type));
    }

    public static class UndoSubject
    extends UndoImpl {
        static final ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoSubject();
            }
        };
        private int _event_mask;

        static UndoSubject getUndo() {
            return (UndoSubject)_factory.getElement();
        }

        @Override
        public String toString() {
            return "UndoSubject " + this.undoable() + ": mask=" + this._event_mask;
        }

        @Override
        public void undo() {
            Subject subject = (Subject)this.undoable();
            subject.forcePublisherMask(this._event_mask);
            super.undo();
        }

        @Override
        public void undoable(Undoable u) {
            super.undoable(u);
            Subject subject = (Subject)u;
            this._event_mask = subject.publisherMask();
        }
    }

    static final class UndoDetachObserver
    extends UndoImpl {
        static final ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoDetachObserver();
            }
        };
        private Observer _observer;

        UndoDetachObserver() {
        }

        static UndoDetachObserver getUndo(Subject subject, Observer observer) {
            UndoDetachObserver undo = (UndoDetachObserver)_factory.getElement();
            undo.undoable(subject);
            undo._observer = observer;
            return undo;
        }

        @Override
        public String toString() {
            return "UndoDetachObserver " + this._observer;
        }

        @Override
        public void undo() {
            Subject subject = (Subject)this.undoable();
            subject.forcedAttachObserver(this._observer);
        }
    }

    static final class UndoAttachObserver
    extends UndoImpl {
        static final ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new UndoAttachObserver();
            }
        };
        Observer _observer;

        UndoAttachObserver() {
        }

        static UndoAttachObserver getUndo(Subject subject, Observer observer) {
            UndoAttachObserver undo = (UndoAttachObserver)_factory.getElement();
            undo.undoable(subject);
            undo._observer = observer;
            return undo;
        }

        @Override
        public String toString() {
            return "UndoAttachObserver " + this._observer;
        }

        @Override
        public void undo() {
            Subject subject = (Subject)this.undoable();
            subject.forcedDetachObserver(this._observer);
        }
    }
}

