/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.ccc;

import java.util.HashMap;
import java.util.Vector;
import org.openl.ie.ccc.CccConst;
import org.openl.ie.ccc.CccConstraint;
import org.openl.ie.ccc.CccExecutable;
import org.openl.ie.ccc.CccFloat;
import org.openl.ie.ccc.CccGoal;
import org.openl.ie.ccc.CccGoalSolution;
import org.openl.ie.ccc.CccGroup;
import org.openl.ie.ccc.CccInteger;
import org.openl.ie.ccc.CccJob;
import org.openl.ie.ccc.CccObject;
import org.openl.ie.ccc.CccProblem;
import org.openl.ie.ccc.CccResource;
import org.openl.ie.ccc.CccVariable;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalCheckSolutionNumber;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.lpsolver.ConstrainerLP;
import org.openl.ie.scheduler.Job;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.Schedule;
import org.openl.util.Log;

public class CccCore
implements CccConst {
    String _name = "null";
    private Vector _integers;
    private Vector _floats;
    private Vector _constraints;
    private Vector _c_active;
    private Vector _c_contr;
    private Vector _goals;
    private Vector _jobs;
    private Vector _resources;
    private Vector groups;
    private Constrainer _constrainer;
    private Schedule _schedule;
    private CccVariable _objective;
    private int _max_solution_num = 99;
    private int _timeout = 30;
    private CccProblem _problem;
    private HashMap _objects;
    private boolean _valid = false;
    private boolean _ok;
    private boolean _failed;
    private boolean _initializing;
    private String _activated_goal_id;
    private int _solution_num;
    private String _status;
    private String _last_failed_id;
    private long _exec_time;

    public synchronized boolean activateAllConstraints() {
        for (int i = 0; i < this.constraints().size(); ++i) {
            String id = (String)this.constraints().elementAt(i);
            if (this.isActivated(id)) continue;
            this.addToActiveList(id);
        }
        if (this.isInitializing()) {
            return true;
        }
        return this.solve();
    }

    public synchronized boolean activateConstraint(String id) {
        this.addToActiveList(id);
        CccConstraint c = this.getConstraintById(id);
        this.traceln("activateConstraint(" + id + ") :" + c);
        if (this.isInitializing()) {
            return true;
        }
        boolean result = this.solve();
        this.setStatus("Activated constraint " + c.name() + ", time: " + this.getExecutionTime() + "ms");
        if (!result) {
            c.status(3);
            this.setLastFailedId(id);
            this.removeFromActiveList(id);
            this.addToContradictionList(id);
        }
        return result;
    }

    public boolean activateGoal(String goal) {
        return this.activateGoal(goal, 1);
    }

    public synchronized boolean activateGoal(String goal, int solution) {
        for (int i = 0; i < this._goals.size(); ++i) {
            this.getGoalByNum(i).status(5);
        }
        this._activated_goal_id = goal;
        this.setSolutionNumber(solution);
        if (this.isInitializing()) {
            return true;
        }
        return this.solve();
    }

    public boolean activateSolution(int n) {
        return this.activateGoal(this.getGoalSolutionId(), n);
    }

    public CccConstraint addConstraint(CccConstraint c) {
        CccGroup g = this.getGroup(this.getConstraintId());
        if (this.isInitializing()) {
            this._constraints.addElement(this.getConstraintId(this._constraints.size()));
        }
        String id = g.add(c);
        this.putObject(id, c);
        if (this.isActivated(id)) {
            this.postConstraint(id);
            try {
                if (c.getSimplex() != null) {
                    c.getSimplex().addConstraint(c.getBoolExp(), false);
                }
            }
            catch (NonLinearExpression e) {
                Log.error((Object)e);
            }
            this.fetchConstrainerState(false);
        }
        return c;
    }

    public CccConstraint addConstraint(Constraint c, String name) throws Exception {
        CccConstraint cc = new CccConstraint(this, name);
        cc.executable(c);
        return this.addConstraint(cc);
    }

    public CccConstraint addConstraint(IntBoolExp e, String name) throws Exception {
        return this.addConstraint(e.asConstraint(), name);
    }

    public CccConstraint addConstraint(IntBoolExp e, String name, ConstrainerLP s) throws Exception {
        CccConstraint cc = new CccConstraint(this, name);
        cc.executable(e.asConstraint());
        cc.setBoolExp(e);
        cc.setSimplex(s);
        return this.addConstraint(cc);
    }

    public CccFloat addFloat(CccFloat f) {
        CccGroup g = this.getGroup(this.getFloatId());
        if (this.isInitializing()) {
            String id = g.add(f);
            this._floats.addElement(id);
        }
        this.putObject(g.add(f), f);
        return f;
    }

    public CccGoal addGoal(CccGoal g) {
        CccGroup grp = this.getGroup(this.getGoalId());
        if (this.isInitializing()) {
            this._goals.addElement(this.getGoalId(this._goals.size()));
        }
        this.putObject(grp.add(g), g);
        return g;
    }

    public CccGoal addGoalMaximize() {
        return this.addGoal(this.objective().getMaximizeGoal());
    }

    public CccGoal addGoalMinimize() {
        return this.addGoal(this.objective().getMinimizeGoal());
    }

    public CccGoal addGoalSolution(Goal solv) {
        CccGoalSolution gs = new CccGoalSolution(this);
        gs.executable(solv);
        return this.addGoal(gs);
    }

    public CccInteger addInteger(CccInteger i) {
        CccGroup g = this.getGroup(this.getIntegerId());
        if (this.isInitializing()) {
            String id = g.add(i);
            this._integers.addElement(id);
        }
        this.putObject(g.add(i), i);
        return i;
    }

    public CccInteger addInteger(IntExp i) {
        CccInteger ci = new CccInteger(this, i);
        return this.addInteger(ci);
    }

    public CccInteger addInteger(IntExp i, String name) {
        CccInteger ci = new CccInteger(this, i, name);
        return this.addInteger(ci);
    }

    public void addIntExpArray(IntExpArray a, String name) {
        CccGroup g = this.getGroup(name);
        for (int i = 0; i < a.size(); ++i) {
            IntExp v = a.get(i);
            CccInteger ci = new CccInteger(this, v);
            g.add(ci);
            if (this.isInitializing()) {
                String id = g.add(ci);
            }
            this.putObject(g.add(ci), ci);
        }
    }

    public CccJob addJob(Job job) {
        CccGroup g = this.getGroup(this.getJobId());
        CccJob j = new CccJob(this, job);
        if (this.isInitializing()) {
            String id = this.getJobId(this._jobs.size());
            this._jobs.addElement(id);
        }
        this.putObject(g.add(j), j);
        return j;
    }

    public void addObjective(CccVariable obj) {
        CccGroup g = this.getGroup(this.getObjectiveId());
        this._objective = obj;
        this._objective.setType(256);
        this.putObject(g.add(this._objective), this._objective);
    }

    public void addObjective(FloatExp e) {
        this.addObjective(new CccFloat(this, e));
    }

    public void addObjective(FloatExp e, String name) {
        this.addObjective(new CccFloat(this, e, name));
    }

    public void addObjective(IntExp e) {
        this.addObjective(new CccInteger(this, e));
    }

    public void addObjective(IntExp e, String name) {
        this.addObjective(new CccInteger(this, e, name));
    }

    public CccResource addResource(Resource resource) {
        CccGroup g = this.getGroup(this.getResourceId());
        CccResource r = new CccResource(this, resource);
        if (this.isInitializing()) {
            String id = this.getResourceId(this._resources.size());
            this._resources.addElement(id);
        }
        this.putObject(g.add(r), r);
        return r;
    }

    protected void addToActiveList(String id) {
        this._c_active.add(id);
    }

    protected void addToContradictionList(String id) {
        if (!this._c_contr.contains(id)) {
            this._c_contr.add(id);
        }
    }

    public synchronized void assignProblem(CccProblem p) {
        this._problem = p;
        this.flush();
        this._status = "Initialized new problem";
        this.setInitializing(true);
        this.reset();
        try {
            this._problem.main(this);
        }
        catch (Exception e) {
            Log.error((Object)"ASSIGN: EXCEPTION DURING _problem.run()", (Throwable)e);
        }
        this.setInitializing(false);
    }

    public Constrainer constrainer() {
        return this._constrainer;
    }

    public void constrainer(Constrainer c) {
        this._constrainer = c;
    }

    public Vector constraints() {
        return this._constraints;
    }

    public Schedule createSchedule(int start, int end) {
        this._schedule = new Schedule(this._constrainer, start, end);
        this._schedule.setName("schedule for " + this._name);
        return this._schedule;
    }

    public synchronized void deactivateAllConstraints() {
        this._c_active.clear();
        this._c_contr.clear();
        if (this.isInitializing()) {
            return;
        }
        this.solve();
    }

    public synchronized void deactivateConstraint(String id) {
        this.removeFromActiveList(id);
        this.removeFromContradictionList(id);
        CccConstraint c = this.getConstraintById(id);
        c.status(5);
        if (this.isInitializing()) {
            return;
        }
        this.solve();
    }

    public synchronized void deactivateGoal() {
        this.activateGoal(null, 1);
    }

    public boolean existsGroup(String name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            CccGroup g = (CccGroup)this.groups.get(i);
            if (!name.equals(g.getName())) continue;
            return true;
        }
        return false;
    }

    protected void fetchConstrainerState(boolean jj) {
        int i;
        for (i = 0; i < this.groups.size(); ++i) {
            CccGroup g = (CccGroup)this.groups.get(i);
            for (int j = 0; j < g.size(); ++j) {
                CccVariable v;
                CccObject o = g.getObject(j);
                if (o instanceof CccInteger) {
                    v = (CccInteger)o;
                    ((CccInteger)v).fetchConstrainerState();
                }
                if (o instanceof CccFloat) {
                    v = (CccFloat)o;
                    ((CccFloat)v).fetchConstrainerState();
                }
                if (o instanceof CccJob) {
                    v = (CccJob)o;
                    ((CccJob)v).fetchConstrainerState();
                }
                if (!(o instanceof CccResource)) continue;
                v = (CccResource)o;
                ((CccResource)v).fetchConstrainerState();
            }
        }
        for (i = 0; i < this._integers.size(); ++i) {
            this.getIntegerByNum(i).fetchConstrainerState();
        }
        for (i = 0; i < this._floats.size(); ++i) {
            this.getFloatByNum(i).fetchConstrainerState();
        }
        for (i = 0; i < this._constraints.size(); ++i) {
            this.getConstraintByNum(i).fetchConstrainerState();
        }
        for (i = 0; i < this._goals.size(); ++i) {
            this.getGoalByNum(i).fetchConstrainerState();
        }
        Vector<String> jon = new Vector<String>();
        for (int i2 = 0; i2 < this._jobs.size(); ++i2) {
            CccJob job = this.getJobByNum(i2);
            if (job.isConstrained()) {
                jon.add(this.getJobId(i2));
                continue;
            }
            job.fetchConstrainerState();
        }
        if (jon.size() > 0) {
            Goal ex = this.getGoalSolution().executable();
            if (jj) {
                this.constrainer().execute(ex, true);
            }
            for (int i3 = 0; i3 < jon.size(); ++i3) {
                CccJob job = this.getJobById((String)jon.elementAt(i3));
                job.fetchConstrainerState();
            }
        }
        for (int i4 = 0; i4 < this._resources.size(); ++i4) {
            this.getResourceByNum(i4).fetchConstrainerState();
        }
        if (this.objective() != null) {
            this.objective().fetchConstrainerState();
        }
    }

    public Vector floats() {
        return this._floats;
    }

    public void flush() {
        this._objects = new HashMap();
        this._schedule = null;
        this._integers = new Vector(10, 5);
        this._floats = new Vector(10, 5);
        this._constraints = new Vector(10, 5);
        this._c_active = new Vector(10, 5);
        this._c_contr = new Vector(10, 5);
        this._jobs = new Vector(10, 5);
        this._resources = new Vector(10, 5);
        this._goals = new Vector(1, 1);
        this.groups = new Vector(10, 5);
        this._activated_goal_id = null;
        this._objective = null;
        this.setSolutionNumber(1);
        this.setOk(true);
    }

    protected CccExecutable getActivatedGoal() {
        return (CccExecutable)this.getObject(this._activated_goal_id);
    }

    public String getActivatedGoalId() {
        return this._activated_goal_id;
    }

    public Vector getActiveList() {
        return this._c_active;
    }

    protected String getByGroupId(CccGroup g, int i) {
        return g.getName() + this.getDivider() + i;
    }

    protected CccConstraint getConstraintById(String id) {
        return (CccConstraint)this._objects.get(id);
    }

    protected CccConstraint getConstraintByNum(int i) {
        return this.getConstraintById(this.getConstraintId(i));
    }

    protected String getConstraintId() {
        return "constraint";
    }

    protected String getConstraintId(int i) {
        return this.getConstraintId() + this.getDivider() + i;
    }

    protected String getDivider() {
        return ",";
    }

    public long getExecutionTime() {
        return this._exec_time;
    }

    protected CccFloat getFloatById(String id) {
        return (CccFloat)this._objects.get(id);
    }

    protected CccFloat getFloatByNum(int i) {
        return this.getFloatById(this.getFloatId(i));
    }

    protected String getFloatId() {
        return "float";
    }

    protected String getFloatId(int i) {
        return this.getFloatId() + this.getDivider() + i;
    }

    protected CccGoal getGoalById(String id) {
        return (CccGoal)this._objects.get(id);
    }

    protected CccGoal getGoalByNum(int i) {
        return this.getGoalById(this.getGoalId(i));
    }

    protected String getGoalId() {
        return "goal";
    }

    protected String getGoalId(int i) {
        return this.getGoalId() + this.getDivider() + i;
    }

    public CccGoalSolution getGoalSolution() {
        CccGoalSolution s = null;
        for (int i = 0; i < this.goals().size(); ++i) {
            CccGoal g = this.getGoalByNum(i);
            if (!(g instanceof CccGoalSolution)) continue;
            s = (CccGoalSolution)g;
            break;
        }
        return s;
    }

    public String getGoalSolutionId() {
        for (int i = 0; i < this.goals().size(); ++i) {
            if (!(this.getGoalByNum(i) instanceof CccGoalSolution)) continue;
            return this.getGoalId(i);
        }
        return null;
    }

    public CccGroup getGroup(String name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            CccGroup g = (CccGroup)this.groups.get(i);
            if (!name.equals(g.getName())) continue;
            return g;
        }
        CccGroup g = new CccGroup(this, name);
        this.groups.add(g);
        return g;
    }

    public Vector getGroups() {
        return this.groups;
    }

    protected CccInteger getIntegerById(String id) {
        return (CccInteger)this._objects.get(id);
    }

    protected CccInteger getIntegerByNum(int i) {
        return this.getIntegerById(this.getIntegerId(i));
    }

    protected String getIntegerId() {
        return "integer";
    }

    protected String getIntegerId(int i) {
        return this.getIntegerId() + this.getDivider() + i;
    }

    protected CccJob getJobById(String id) {
        return (CccJob)this._objects.get(id);
    }

    protected CccJob getJobByNum(int i) {
        return this.getJobById(this.getJobId(i));
    }

    protected String getJobId() {
        return "job";
    }

    protected String getJobId(int i) {
        return this.getJobId() + this.getDivider() + i;
    }

    public boolean getLastFailed() {
        return this._failed;
    }

    public String getLastFailedId() {
        return this._last_failed_id;
    }

    public int getMaxSolutionNum() {
        return this._max_solution_num;
    }

    protected CccObject getObject(String id) {
        return (CccObject)this._objects.get(id);
    }

    protected CccObject getObject(String id, int i) {
        return (CccObject)this._objects.get(id + this.getDivider() + i);
    }

    protected CccVariable getObjectiveById(String id) {
        return (CccVariable)this._objects.get(id);
    }

    protected CccVariable getObjectiveByNum(int i) {
        return this.getObjectiveById(this.getObjectiveId(i));
    }

    protected String getObjectiveId() {
        return "objective";
    }

    protected String getObjectiveId(int i) {
        return this.getObjectiveId() + this.getDivider() + i;
    }

    protected CccResource getResourceById(String id) {
        return (CccResource)this._objects.get(id);
    }

    protected CccResource getResourceByNum(int i) {
        return this.getResourceById(this.getResourceId(i));
    }

    protected String getResourceId() {
        return "resource";
    }

    protected String getResourceId(int i) {
        return this.getResourceId() + this.getDivider() + i;
    }

    public int getSolutionNumber() {
        return this._solution_num;
    }

    public String getStatus() {
        return this._status;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public Vector goals() {
        return this._goals;
    }

    public Vector integers() {
        return this._integers;
    }

    public boolean isActivated(String s) {
        if (s.equals(this._activated_goal_id)) {
            return true;
        }
        if (this._c_active.contains(s)) {
            return true;
        }
        return this._c_contr.contains(s);
    }

    public boolean isIncompatible(String s) {
        return this._c_contr.contains(s);
    }

    protected boolean isInitializing() {
        return this._initializing;
    }

    protected boolean isOk() {
        return this._ok;
    }

    public Vector jobs() {
        return this._jobs;
    }

    public String name() {
        return this._name;
    }

    public CccVariable objective() {
        return this._objective;
    }

    protected boolean postConstraint(String id) {
        CccConstraint ct = null;
        try {
            ct = this.getConstraintById(id);
            Constraint constraint = (Constraint)ct.executable();
            this.traceln("Activating C: " + ct);
            this.constrainer().postConstraint(constraint);
            this.traceln("C:" + ct + " activated!");
            ct.status(6);
            if (this.removeFromContradictionList(id)) {
                this.addToActiveList(id);
            }
        }
        catch (Failure f) {
            if (ct != null) {
                this.traceln(" WRONG: Failure to activate " + ct + ", " + this.isActivated(ct.getId()));
                this.removeFromActiveList(id);
                this.addToContradictionList(id);
                this.setLastFailedId(id);
                ct.status(3);
                this.setLastFailed(true);
            } else {
                this.traceln("Impossible Failure in executeActivatedConstraints()");
            }
        }
        catch (Exception e) {
            Log.debug((Object)"!postConstraint() exception", (Throwable)e);
            System.exit(0);
        }
        return true;
    }

    protected void putObject(String id, CccObject o) {
        o.setId(id);
        this._objects.put(id, o);
    }

    protected boolean removeFromActiveList(String id) {
        return this._c_active.remove(id);
    }

    protected boolean removeFromContradictionList(String id) {
        return this._c_contr.remove(id);
    }

    private void reset() {
        this._constrainer = new Constrainer("");
        this._constrainer.setTimeLimit(this.getTimeout());
        for (int i = 0; i < this.groups.size(); ++i) {
            CccGroup g = (CccGroup)this.groups.get(i);
            g.reset();
        }
        this.setLastFailedId(null);
        this.setLastFailed(false);
    }

    public Vector resources() {
        return this._resources;
    }

    public Schedule schedule() {
        return this._schedule;
    }

    public void setExecutionTime(long t) {
        this._exec_time = t;
    }

    protected void setInitializing(boolean f) {
        this._initializing = f;
    }

    public void setLastFailed(boolean f) {
        this._failed = f;
    }

    public void setLastFailedId(String id) {
        this._last_failed_id = id;
    }

    public void setMaxSolutionNum(int n) {
        this._max_solution_num = n;
    }

    protected void setOk(boolean f) {
        this._ok = f;
    }

    public void setSolutionNumber(int n) {
        this._solution_num = n;
    }

    public void setStatus(String s) {
        this.traceln("STATUS: " + s);
        this._status = s;
    }

    public void setTimeout(int n) {
        this._timeout = n;
    }

    protected synchronized boolean solve() {
        this.traceln("[--------------------------------------] > solve()");
        this.reset();
        long time1 = System.currentTimeMillis();
        try {
            try {
                this.traceln("RUNNIG PROBLEM");
                this._problem.main(this);
            }
            catch (Exception e) {
                Log.error((Object)"EXCEPTION DURING _problem.run()", (Throwable)e);
                throw e;
            }
            this.traceln("EXECUTION GOAL");
            if (this.getActivatedGoalId() != null) {
                boolean res = false;
                if (this.getSolutionNumber() > 1) {
                    int n = this.getSolutionNumber();
                    this.traceln("Looking for solution #" + n);
                    GoalCheckSolutionNumber chk = new GoalCheckSolutionNumber(this.constrainer(), n);
                    GoalAnd goal = new GoalAnd(this.getGoalById(this.getActivatedGoalId()).executable(), chk);
                    res = this.constrainer().execute(goal);
                    this.setSolutionNumber(chk.getCurrentSolutionNumber());
                } else {
                    Goal goal = this.getGoalById(this.getActivatedGoalId()).executable();
                    res = this.constrainer().execute(goal);
                }
                this.getGoalById(this.getActivatedGoalId()).status(6);
                this.traceVars();
                if (!res) {
                    throw new Exception("Goal exec failed");
                }
            }
            if (this.isOk()) {
                this.setOk(!this.getLastFailed());
            } else {
                this.setOk(!this.getLastFailed());
                this.setLastFailed(false);
            }
            this.traceln("+getLastFailed() = " + this.getLastFailed());
            this.traceln("+isOk() = " + this.isOk());
        }
        catch (Exception e) {
            Log.debug((Object)"Failure during execution.");
            if (this.getActivatedGoalId() != null) {
                this.getGoalById(this.getActivatedGoalId()).status(3);
            }
            if (this.isOk()) {
                Log.debug((Object)"ACTIVATION FAILURE");
                this.setLastFailed(true);
            }
            this.setOk(false);
        }
        this.setExecutionTime(System.currentTimeMillis() - time1);
        Log.debug((Object)("Execution time: " + this.getExecutionTime() + "ms // of " + this.getTimeout() * 1000));
        if (this.getExecutionTime() > (long)(this.getTimeout() * 1000)) {
            Log.debug((Object)("Execution timeout - extra: " + (this.getExecutionTime() - (long)(this.getTimeout() * 1000)) + "ms"));
            this.setStatus("Timeout during execution: " + this.getExecutionTime() + "ms");
            this.setOk(false);
        }
        this.fetchConstrainerState(true);
        this.traceln("[--------------------------------------] solve() >");
        return this.isOk();
    }

    public String stat() {
        return this._constrainer.toString() + (this._schedule != null ? this._schedule.toString() : "");
    }

    public void traceError(String s) {
        Log.error((Object)s);
    }

    public void traceln(String s) {
    }

    public void traceVars() {
    }
}

