/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintConst;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.impl.ConstraintFloatExpEqualsValue;
import org.openl.ie.constrainer.impl.ConstraintFloatExpLessValue;
import org.openl.ie.constrainer.impl.ConstraintFloatExpMoreValue;
import org.openl.ie.constrainer.impl.FloatExpAddValue;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpConst
extends FloatExpImpl {
    private double _const;

    public FloatExpConst(Constrainer constrainer, double c) {
        super(constrainer, Double.toString(c));
        this._const = c;
    }

    public FloatExp add(double value) {
        return this.getFloatExp(FloatExpConst.class, this._const + value);
    }

    public FloatExp add(FloatExp exp) {
        return this.getFloatExp(FloatExpAddValue.class, exp, this._const);
    }

    public boolean bound() {
        return true;
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._const * factor;
    }

    public FloatExp div(double c) {
        if (c == 0.0) {
            throw new IllegalArgumentException("Division by zero");
        }
        return this.getFloatExp(FloatExpConst.class, this._const / c);
    }

    public Constraint equals(double value) {
        return new ConstraintConst(this.constrainer(), value == this._const);
    }

    public Constraint equals(FloatExp exp) {
        return new ConstraintFloatExpEqualsValue(exp, this._const);
    }

    public Constraint equals(FloatExp exp, double value) {
        return new ConstraintFloatExpEqualsValue(exp, this._const - value);
    }

    public boolean isLinear() {
        return true;
    }

    public Constraint lessOrEqual(double value) {
        return new ConstraintConst(this.constrainer(), this._const <= value);
    }

    public Constraint lessOrEqual(FloatExp exp) {
        return new ConstraintFloatExpMoreValue(exp, this._const);
    }

    public double max() {
        return this._const;
    }

    public double min() {
        return this._const;
    }

    public Constraint moreOrEqual(double value) {
        return new ConstraintConst(this.constrainer(), this._const >= value);
    }

    public Constraint moreOrEqual(FloatExp exp) {
        return new ConstraintFloatExpLessValue(exp, this._const);
    }

    public FloatExp mul(double c) {
        return this.getFloatExp(FloatExpConst.class, this._const * c);
    }

    public FloatExp neg() {
        return this.getFloatExp(FloatExpConst.class, -this._const);
    }

    public void propagate() throws Failure {
    }

    public void setMax(double max) throws Failure {
        if (max < this._const) {
            this.constrainer().fail("max<const");
        }
    }

    public void setMin(double min) throws Failure {
        if (min > this._const) {
            this.constrainer().fail("min>const");
        }
    }

    public void setValue(double value) throws Failure {
        if (value != this._const) {
            this.constrainer().fail("value!=const");
        }
    }

    public FloatExp sub(FloatExp exp) {
        return exp.neg().add(this._const);
    }

    public String toString() {
        return "[" + this._const + "]";
    }

    public double value() throws Failure {
        return this._const;
    }
}

