/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Debug;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.util.Log;

public class GoalFloatMinimize
extends GoalImpl {
    private FloatExp _cost;
    private Goal _find_solution;
    private double _best_cost_min;
    private double _best_cost_max;
    private int _number_of_choice_points;
    private int _number_of_failures;

    public GoalFloatMinimize(Goal goal, FloatExp cost) {
        super(cost.constrainer(), "Use " + goal.name() + " to minimize(" + cost.name() + ")");
        this._find_solution = goal;
        this._cost = cost;
        this._best_cost_max = this._cost.max();
        this._best_cost_min = this._cost.min();
        this._number_of_choice_points = 0;
        this._number_of_failures = 0;
    }

    private double bestCostMax() {
        return this._best_cost_max;
    }

    private void bestCostMax(double max) {
        this._best_cost_max = max;
    }

    private double bestCostMin() {
        return this._best_cost_min;
    }

    private void bestCostMin(double min) {
        this._best_cost_min = min;
    }

    private Constrainer C() {
        return this._cost.constrainer();
    }

    public FloatExp cost() {
        return this._cost;
    }

    public Goal execute() throws Failure {
        Debug.on();
        Debug.print("Dichotomize with cost[" + this.bestCostMin() + ";" + this.bestCostMax() + "]");
        Debug.off();
        double best_cost = (this.bestCostMin() + this.bestCostMax()) / 2.0;
        if (this.bestCostMax() - this.bestCostMin() <= Constrainer.FLOAT_PRECISION) {
            this.C().numberOfChoicePoints(this._number_of_choice_points);
            this.C().numberOfFailures(this._number_of_failures);
            Log.info((Object)("Minimize Succeeded. Total Choice Points=" + this._number_of_choice_points + " Failures=" + this._number_of_failures));
            return new GoalAnd(this.setCost(), this.findSolution());
        }
        boolean restore = true;
        Debug.on();
        Debug.print(this.cost().domainToString() + ". Try cost>=" + this.bestCostMin() + " and <=" + best_cost);
        Debug.off();
        if (!this.C().execute((Goal)new GoalAnd(this.cost().moreOrEqual(this.bestCostMin()), this.cost().lessOrEqual(best_cost), this.findSolution()), restore)) {
            Debug.on();
            Debug.print("Failure for cost <= " + best_cost);
            Debug.off();
            this.bestCostMin(best_cost);
        } else {
            this.bestCostMax(best_cost);
            Debug.on();
            Debug.print("Found solution with the cost <= " + best_cost);
            Debug.off();
        }
        this._number_of_choice_points += this.C().numberOfChoicePoints();
        this._number_of_failures += this.C().numberOfFailures();
        return this;
    }

    public Goal findSolution() {
        return this._find_solution;
    }

    public Goal setCost() {
        Debug.on();
        Debug.print("Set Cost [ " + this.bestCostMin() + " ; " + this.bestCostMax() + " ]");
        Debug.off();
        return new GoalAnd(this._cost.lessOrEqual(this.bestCostMax()), this._cost.moreOrEqual(this.bestCostMin()));
    }
}

