/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.io.Serializable;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.GoalOr;
import org.openl.ie.constrainer.GoalRemoveValue;
import org.openl.ie.constrainer.GoalSetMax;
import org.openl.ie.constrainer.GoalSetMin;
import org.openl.ie.constrainer.GoalSetValue;
import org.openl.ie.constrainer.IntValueSelector;
import org.openl.ie.constrainer.IntValueSelectorMin;
import org.openl.ie.constrainer.IntVar;

public class GoalInstantiate
extends GoalImpl {
    private IntVar _intvar;
    private IntValueSelector _selector;
    private Impl _impl;

    public GoalInstantiate(IntVar intvar) {
        this(intvar, new IntValueSelectorMin(), true);
    }

    public GoalInstantiate(IntVar intvar, IntValueSelector selector) {
        this(intvar, selector, true);
    }

    public GoalInstantiate(IntVar intvar, IntValueSelector selector, boolean recursive) {
        super(intvar.constrainer(), "");
        this._intvar = intvar;
        this._selector = selector;
        this._impl = recursive ? new RecursiveImpl() : new NonRecursiveImpl();
    }

    public Goal execute() throws Failure {
        if (this._intvar.size() == 1) {
            return null;
        }
        int chosen_value = this._selector.select(this._intvar);
        return this._impl.instantiate(chosen_value);
    }

    public String toString() {
        return "Instantiate(" + this._intvar.name() + ")";
    }

    class RecursiveImpl
    implements Impl {
        private GoalSetValue _goal_value;
        private GoalRemoveValue _goal_remove;
        private GoalSetMin _goal_min;
        private GoalSetMax _goal_max;

        public RecursiveImpl() {
            this._goal_value = new GoalSetValue(GoalInstantiate.this._intvar);
            if (GoalInstantiate.this._intvar.domainType() != 0) {
                this._goal_remove = new GoalRemoveValue(GoalInstantiate.this._intvar);
            } else {
                this._goal_min = new GoalSetMin(GoalInstantiate.this._intvar);
                this._goal_max = new GoalSetMax(GoalInstantiate.this._intvar);
            }
        }

        public Goal instantiate(int chosen_value) throws Failure {
            GoalImpl goal_limit;
            this._goal_value.value(chosen_value);
            if (GoalInstantiate.this._intvar.domainType() != 0) {
                this._goal_remove.value(chosen_value);
                goal_limit = this._goal_remove;
            } else if (chosen_value == GoalInstantiate.this._intvar.min()) {
                this._goal_min.min(chosen_value + 1);
                goal_limit = this._goal_min;
            } else {
                this._goal_max.max(chosen_value - 1);
                goal_limit = this._goal_max;
            }
            return new GoalOr(this._goal_value, new GoalAnd(goal_limit, GoalInstantiate.this));
        }
    }

    class NonRecursiveImpl
    implements Impl {
        public Goal instantiate(int chosen_value) throws Failure {
            GoalSetValue goal_value = new GoalSetValue(GoalInstantiate.this._intvar, chosen_value);
            GoalImpl goal_limit = GoalInstantiate.this._intvar.domainType() != 0 ? new GoalRemoveValue(GoalInstantiate.this._intvar, chosen_value) : (chosen_value == GoalInstantiate.this._intvar.min() ? new GoalSetMin(GoalInstantiate.this._intvar, chosen_value + 1) : new GoalSetMax(GoalInstantiate.this._intvar, chosen_value - 1));
            return new GoalOr(goal_value, goal_limit);
        }
    }

    static interface Impl
    extends Serializable {
        public Goal instantiate(int var1) throws Failure;
    }
}

