/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;

public final class ConstraintExpEqualsExp
extends ConstraintImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private int _offset;

    public ConstraintExpEqualsExp(IntExp exp1, IntExp exp2) {
        this(exp1, exp2, 0);
    }

    public ConstraintExpEqualsExp(IntExp exp1, IntExp exp2, int offset) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._offset = offset;
        if (this.constrainer().showInternalNames()) {
            this._name = offset == 0 ? "(" + exp1.name() + "==" + exp2.name() + ")" : (offset > 0 ? "(" + exp1.name() + "==" + exp2.name() + "+" + offset + ")" : "(" + exp1.name() + "==" + exp2.name() + offset + ")");
        }
    }

    public Goal execute() throws Failure {
        this.minmax();
        class ObserverEqual
        extends Observer {
            ObserverEqual() {
            }

            public Object master() {
                return ConstraintExpEqualsExp.this;
            }

            public int subscriberMask() {
                return 14;
            }

            public String toString() {
                return ConstraintExpEqualsExp.this._name + "(MinMax)";
            }

            public void update(Subject exp, EventOfInterest interest) throws Failure {
                IntEvent event = (IntEvent)interest;
                if (event.isRemoveEvent()) {
                    int max = event.numberOfRemoves();
                    for (int i = 0; i < max; ++i) {
                        if (exp == ConstraintExpEqualsExp.this._exp1) {
                            ConstraintExpEqualsExp.this._exp2.removeValue(event.removed(i) - ConstraintExpEqualsExp.this._offset);
                            continue;
                        }
                        if (exp != ConstraintExpEqualsExp.this._exp2) continue;
                        ConstraintExpEqualsExp.this._exp1.removeValue(event.removed(i) + ConstraintExpEqualsExp.this._offset);
                    }
                } else {
                    ConstraintExpEqualsExp.this.minmax();
                }
            }
        }
        ObserverEqual observer = new ObserverEqual();
        this._exp1.attachObserver(observer);
        this._exp2.attachObserver(observer);
        return null;
    }

    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    public void minmax() throws Failure {
        this._exp1.setMax(this._exp2.max() + this._offset);
        this._exp2.setMax(this._exp1.max() - this._offset);
        this._exp1.setMin(this._exp2.min() + this._offset);
        this._exp2.setMin(this._exp1.min() - this._offset);
    }

    public IntBoolExp toIntBoolExp() {
        return this._exp1.eq(this._exp2.add(this._offset));
    }

    public String toString() {
        return this._exp1 + "==" + this._exp2;
    }
}

