/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.ExpressionFactory;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ConstraintExpNotValue;
import org.openl.ie.constrainer.impl.IntBoolExpEqValue;
import org.openl.ie.constrainer.impl.IntEvent;

public final class ConstraintExpEqualsValue
extends ConstraintImpl {
    private IntExp _exp;
    private int _value;
    private Constraint _opposite;

    public ConstraintExpEqualsValue(IntExp exp, int value) {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "==" + value + ")";
        }
        this._exp = exp;
        this._value = value;
    }

    public Goal execute() throws Failure {
        this._exp.setValue(this._value);
        class ObserverEqualValue
        extends Observer {
            ObserverEqualValue() {
            }

            public Object master() {
                return ConstraintExpEqualsValue.this;
            }

            public int subscriberMask() {
                return 7;
            }

            public String toString() {
                return "ObserverEqualValue";
            }

            public void update(Subject exp, EventOfInterest interest) throws Failure {
                IntEvent event = (IntEvent)interest;
                if (event.isValueEvent() && event.min() != ConstraintExpEqualsValue.this._value || event.isMaxEvent() && event.max() < ConstraintExpEqualsValue.this._value || event.isMinEvent() && event.min() > ConstraintExpEqualsValue.this._value) {
                    exp.constrainer().fail("from ObserverEqualValue");
                }
                ConstraintExpEqualsValue.this._exp.setValue(ConstraintExpEqualsValue.this._value);
            }
        }
        this._exp.attachObserver(new ObserverEqualValue());
        return null;
    }

    public boolean isLinear() {
        return this._exp.isLinear();
    }

    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintExpNotValue(this._exp, this._value);
        }
        return this._opposite;
    }

    public IntBoolExp toIntBoolExp() {
        ExpressionFactory factory = this.constrainer().expressionFactory();
        Class<IntBoolExpEqValue> clazz = IntBoolExpEqValue.class;
        Object[] args = new Object[]{this._exp, new Integer(this._value)};
        Class[] types = new Class[]{IntExp.class, Integer.TYPE};
        return (IntBoolExpEqValue)factory.getExpression(clazz, args, types);
    }

    public String toString() {
        return this._exp + "=" + this._value;
    }
}

