/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;

public final class ConstraintExpLessExp
extends ConstraintImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private int _offset;
    private Constraint _opposite;

    public ConstraintExpLessExp(IntExp exp1, IntExp exp2, int offset) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._offset = offset;
        this._opposite = null;
        if (this.constrainer().showInternalNames()) {
            this._name = offset == 0 ? "(" + exp1.name() + "<=" + exp2.name() + ")" : (offset > 0 ? "(" + exp1.name() + "<=" + exp2.name() + "+" + offset + ")" : "(" + exp1.name() + "<=" + exp2.name() + offset + ")");
        }
    }

    public Goal execute() throws Failure {
        this._exp1.setMax(this._exp2.max() - this._offset);
        this._exp1.attachObserver(new ObserverExp1Min());
        this._exp2.setMin(this._exp1.min() + this._offset);
        this._exp2.attachObserver(new ObserverExp2Max());
        return null;
    }

    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintExpLessExp(this._exp2, this._exp1, -this._offset + 1);
        }
        return this._opposite;
    }

    public IntBoolExp toIntBoolExp() {
        return this._exp1.le(this._exp2.add(this._offset));
    }

    public String toString() {
        return this._exp1 + "<" + this._exp2;
    }

    class ObserverExp2Max
    extends Observer {
        ObserverExp2Max() {
        }

        public Object master() {
            return ConstraintExpLessExp.this;
        }

        public int subscriberMask() {
            return 4;
        }

        public String toString() {
            return ConstraintExpLessExp.this._name + "(max:" + ConstraintExpLessExp.this._exp2.name() + ")";
        }

        public void update(Subject exp, EventOfInterest interest) throws Failure {
            ConstraintExpLessExp.this._exp1.setMax(ConstraintExpLessExp.this._exp2.max() - ConstraintExpLessExp.this._offset);
        }
    }

    class ObserverExp1Min
    extends Observer {
        ObserverExp1Min() {
        }

        public Object master() {
            return ConstraintExpLessExp.this;
        }

        public int subscriberMask() {
            return 2;
        }

        public String toString() {
            return ConstraintExpLessExp.this._name + "(min:" + ConstraintExpLessExp.this._exp1.name() + ")";
        }

        public void update(Subject exp, EventOfInterest interest) throws Failure {
            ConstraintExpLessExp.this._exp2.setMin(ConstraintExpLessExp.this._exp1.min() + ConstraintExpLessExp.this._offset);
        }
    }
}

