/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;

public final class ConstraintFloatExpEqualsExp
extends ConstraintImpl {
    private FloatExp _exp1;
    private FloatExp _exp2;
    private double _offset;

    public ConstraintFloatExpEqualsExp(FloatExp exp1, FloatExp exp2) {
        this(exp1, exp2, 0.0);
    }

    public ConstraintFloatExpEqualsExp(FloatExp exp1, FloatExp exp2, double offset) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._offset = offset;
        if (this.constrainer().showInternalNames()) {
            this._name = offset == 0.0 ? "(" + exp1.name() + "=" + exp2.name() + ")" : (offset > 0.0 ? "(" + exp1.name() + "=" + exp2.name() + "+" + offset + ")" : "(" + exp1.name() + "=" + exp2.name() + offset + ")");
        }
    }

    public Goal execute() throws Failure {
        this.minmax();
        ObserverFloatEqual observer = new ObserverFloatEqual();
        this._exp1.attachObserver(observer);
        this._exp2.attachObserver(observer);
        return null;
    }

    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    public void minmax() throws Failure {
        this._exp1.setMax(this._exp2.max() + this._offset);
        this._exp2.setMax(this._exp1.max() - this._offset);
        this._exp1.setMin(this._exp2.min() + this._offset);
        this._exp2.setMin(this._exp1.min() - this._offset);
    }

    public IntBoolExp toIntBoolExp() {
        return this._exp1.eq(this._exp2.add(this._offset));
    }

    public String toString() {
        return this._exp1 + "=" + this._exp2;
    }

    class ObserverFloatEqual
    extends Observer {
        ObserverFloatEqual() {
        }

        public Object master() {
            return ConstraintFloatExpEqualsExp.this;
        }

        public int subscriberMask() {
            return 6;
        }

        public String toString() {
            return ConstraintFloatExpEqualsExp.this._name + "(ObserverFloatEqual)";
        }

        public void update(Subject exp, EventOfInterest interest) throws Failure {
            FloatEvent event = (FloatEvent)interest;
            ConstraintFloatExpEqualsExp.this.minmax();
        }
    }
}

