/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.impl.DomainImpl;

public final class DomainBits
extends DomainImpl {
    private boolean[] _bits;
    private int _size;

    public DomainBits(IntVar var, int min, int max) {
        super(var, min, max);
        this._bits = new boolean[max - min + 1];
        for (int i = 0; i < this._bits.length; ++i) {
            this._bits[i] = true;
        }
        this._size = this._max - this._min + 1;
    }

    public boolean[] bits() {
        return this._bits;
    }

    void checkX(String s) {
        if (!this._bits[this._min - this._initial_min]) {
            Constrainer.abort("From:" + s + "!_bits[_min - _initial_min] " + this);
        }
        if (!this._bits[this._max - this._initial_min]) {
            Constrainer.abort("From:" + s + "  !_bits[_max - _initial_min] " + this);
        }
    }

    public boolean contains(int value) {
        if (value < this._min || value > this._max) {
            return false;
        }
        return this._bits[value - this._initial_min];
    }

    public void forceBits(boolean[] bits) {
        this._bits = bits;
    }

    public void forceInsert(int val) {
        this._bits[val - this._initial_min] = true;
    }

    public void forceSize(int val) {
        this._size = val;
    }

    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        for (int i = this._min - this._initial_min; i <= this._max - this._initial_min; ++i) {
            if (!this._bits[i] || it.doSomethingOrStop(i + this._initial_min)) continue;
            return;
        }
    }

    public int max() {
        return this._max;
    }

    public int min() {
        return this._min;
    }

    String printBits() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._bits.length; ++i) {
            if (this._bits[i]) {
                if (this._initial_min + i < this._min || this._initial_min + i > this._max) {
                    buf.append('x');
                    continue;
                }
                buf.append('X');
                continue;
            }
            if (this._initial_min + i < this._min || this._initial_min + i > this._max) {
                buf.append('o');
                continue;
            }
            buf.append('O');
        }
        return buf.toString();
    }

    String printIntervals() {
        StringBuffer buf = new StringBuffer();
        int i = this._min;
        while (i <= this._max) {
            int from;
            int to;
            if (i != this._min) {
                buf.append(" ");
            }
            if ((to = this.upperBound(from = i)) - from == 1) {
                buf.append(String.valueOf(from));
            } else {
                buf.append(from + ".." + (to - 1));
            }
            i = this.upperBound(to);
        }
        return buf.toString();
    }

    public boolean removeRange(int min, int max) throws Failure {
        if (min <= this._min && max >= this._max) {
            this.constrainer().fail("Empty domain");
        }
        if (min <= this._min && max >= this._min) {
            return this.setMin(max + 1);
        }
        if (max >= this._max && min <= this._max) {
            return this.setMax(min - 1);
        }
        boolean is_removed = false;
        for (int i = min; i <= max; ++i) {
            if (!this.contains(i)) continue;
            this._variable.addUndo();
            this._bits[i - this._initial_min] = false;
            --this._size;
            is_removed = true;
        }
        return is_removed;
    }

    public boolean removeValue(int value) throws Failure {
        if (!this.contains(value)) {
            return false;
        }
        if (value == this._min) {
            return this.setMin(value + 1);
        }
        if (value == this._max) {
            return this.setMax(value - 1);
        }
        this._variable.addUndo();
        this._bits[value - this._initial_min] = false;
        --this._size;
        return true;
    }

    public boolean setMax(int M) throws Failure {
        if (M >= this._max) {
            return false;
        }
        if (M < this._min) {
            this.constrainer().fail("Max < Min ");
        }
        this._variable.addUndo();
        while (this._max > M) {
            if (!this._bits[this._max-- - this._initial_min]) continue;
            --this._size;
        }
        for (int i = this._max - this._initial_min; i >= 0 && !this._bits[i]; --i) {
            if (--this._max >= this._min) continue;
            this.constrainer().fail("max");
        }
        return true;
    }

    public boolean setMin(int m) throws Failure {
        if (m <= this._min) {
            return false;
        }
        if (m > this._max) {
            this.constrainer().fail("Min > Max ");
        }
        this._variable.addUndo();
        while (this._min < m) {
            if (!this._bits[this._min++ - this._initial_min]) continue;
            --this._size;
        }
        for (int i = this._min - this._initial_min; i < this._bits.length && !this._bits[i]; ++i) {
            if (++this._min <= this._max) continue;
            this.constrainer().fail("min");
        }
        return true;
    }

    public boolean setValue(int value) throws Failure {
        if (this._min == value && this._max == value) {
            return false;
        }
        if (!this.contains(value)) {
            this.constrainer().fail("attempt to set invalid value");
        }
        this._variable.addUndo();
        this._min = value;
        this._max = value;
        this._size = 1;
        return true;
    }

    public int size() {
        return this._size;
    }

    public String toString() {
        return "[" + this.printIntervals() + "]";
    }

    public int type() {
        return 1;
    }

    int upperBound(int i) {
        if (i > this._max) {
            return i;
        }
        boolean sample = this._bits[i - this._initial_min];
        int j = i;
        while (j <= this._max && this._bits[j - this._initial_min] == sample) {
            ++j;
        }
        return j;
    }
}

