/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Domain;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;

public class DomainImpl
implements Domain {
    protected IntVar _variable;
    protected int _initial_min;
    protected int _initial_max;
    protected int _min;
    protected int _max;

    public DomainImpl(IntVar var, int min, int max) {
        this._variable = var;
        this._initial_min = min;
        this._initial_max = max;
        this._min = min;
        this._max = max;
    }

    public Constrainer constrainer() {
        return this._variable.constrainer();
    }

    public boolean contains(int value) {
        return value >= this._min && value <= this._max;
    }

    public void forceInsert(int val) {
    }

    public void forceMax(int max) {
        this._max = max;
    }

    public void forceMin(int min) {
        this._min = min;
    }

    public void forceSize(int val) {
    }

    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        for (int i = this._min; i <= this._max; ++i) {
            if (it.doSomethingOrStop(i)) continue;
            return;
        }
    }

    public int max() {
        return this._max;
    }

    public int min() {
        return this._min;
    }

    public boolean removeRange(int min, int max) throws Failure {
        boolean is_removed = false;
        if (min <= this._min && max >= this._max) {
            this.constrainer().fail("Empty domain");
        }
        if (min <= this._min && max >= this._min) {
            return this.setMin(max + 1);
        }
        if (max >= this._max && min <= this._max) {
            return this.setMax(min - 1);
        }
        return is_removed;
    }

    public boolean removeValue(int value) throws Failure {
        if (value == this.min()) {
            return this.setMin(value + 1);
        }
        if (value == this.max()) {
            return this.setMax(value - 1);
        }
        return false;
    }

    public boolean setMax(int M) throws Failure {
        if (M >= this._max) {
            return false;
        }
        if (M < this._min) {
            this.constrainer().fail("DomainImpl setMax");
        }
        this._variable.addUndo();
        this._max = M;
        return true;
    }

    public boolean setMin(int m) throws Failure {
        if (m <= this._min) {
            return false;
        }
        if (m > this._max) {
            this.constrainer().fail("DomainImpl setMin");
        }
        this._variable.addUndo();
        this._min = m;
        return true;
    }

    public boolean setValue(int value) throws Failure {
        if (this._min == value && this._max == value) {
            return false;
        }
        if (!this.contains(value)) {
            this.constrainer().fail("DomainImpl setValue");
        }
        this._variable.addUndo();
        this._min = value;
        this._max = value;
        return true;
    }

    public int size() {
        return this._max - this._min + 1;
    }

    public String toString() {
        return "[" + this.min() + (this.size() == 1 ? "" : ";" + this.max()) + "]";
    }

    public int type() {
        return 0;
    }

    public void variable(IntVar var) {
        this._variable = var;
    }
}

