/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpExponent
extends FloatExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private FloatExp _exp;
    private ExpressionObserver _observer;

    public FloatExpExponent(FloatExp exp) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._observer = new FloatExpExponentObserver();
        this._exp.attachObserver(this._observer);
    }

    public double max() {
        return Math.exp(this._exp.max());
    }

    public double min() {
        return Math.exp(this._exp.min());
    }

    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    public void setMax(double max) throws Failure {
        if (max < 0.0) {
            this.constrainer().fail("max < 0");
        }
        this._exp.setMax(Math.log(max));
    }

    public void setMin(double min) throws Failure {
        if (min <= 0.0) {
            return;
        }
        this._exp.setMin(Math.log(min));
    }

    public void setValue(double value) throws Failure {
        if (value <= 0.0) {
            this.constrainer().fail("value <= 0");
        }
        this._exp.setValue(Math.log(value));
    }

    public String toString() {
        return "exp(" + this._exp + ")" + this.domainToString();
    }

    class FloatExpExponentObserver
    extends ExpressionObserver {
        FloatExpExponentObserver() {
            super(event_map);
        }

        public Object master() {
            return FloatExpExponent.this;
        }

        public String toString() {
            return "FloatExpExponentObserver: " + FloatExpExponent.this._exp;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventExponent ev = FloatEventExponent.getEvent(e, FloatExpExponent.this);
            FloatExpExponent.this.notifyObservers(ev);
        }
    }

    static final class FloatEventExponent
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FloatEventExponent();
            }
        };
        FloatEvent _event;
        int _type = 0;

        FloatEventExponent() {
        }

        static FloatEventExponent getEvent(FloatEvent event, FloatExp exp) {
            FloatEventExponent ev = (FloatEventExponent)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        void init(FloatEvent event, FloatExp exp_) {
            this.exp(exp_);
            this._event = event;
            this._type = 0;
            if (this.max() < this.oldmax()) {
                this._type |= 4;
            }
            if (this.min() > this.oldmin()) {
                this._type |= 2;
            }
            if (this.min() == this.max()) {
                this._type |= 1;
            }
        }

        public double max() {
            return Math.exp(this._event.max());
        }

        public double min() {
            return Math.exp(this._event.min());
        }

        public String name() {
            return "FloatEventExponent";
        }

        public double oldmax() {
            return Math.exp(this._event.oldmax());
        }

        public double oldmin() {
            return Math.exp(this._event.oldmin());
        }

        public int type() {
            return this._type;
        }
    }
}

