/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpConst;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.impl.ConstraintFloatExpEqualsExp;
import org.openl.ie.constrainer.impl.ConstraintFloatExpEqualsValue;
import org.openl.ie.constrainer.impl.ConstraintFloatExpLessExp;
import org.openl.ie.constrainer.impl.ConstraintFloatExpLessValue;
import org.openl.ie.constrainer.impl.ConstraintFloatExpMoreValue;
import org.openl.ie.constrainer.impl.ExpressionImpl;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.FloatExpAbs;
import org.openl.ie.constrainer.impl.FloatExpAddExp;
import org.openl.ie.constrainer.impl.FloatExpAddValue;
import org.openl.ie.constrainer.impl.FloatExpExponent;
import org.openl.ie.constrainer.impl.FloatExpInverse;
import org.openl.ie.constrainer.impl.FloatExpLog;
import org.openl.ie.constrainer.impl.FloatExpMulExp;
import org.openl.ie.constrainer.impl.FloatExpMultiplyPositive;
import org.openl.ie.constrainer.impl.FloatExpOpposite;
import org.openl.ie.constrainer.impl.FloatExpPowIntValue;
import org.openl.ie.constrainer.impl.FloatExpPowValue;
import org.openl.ie.constrainer.impl.FloatExpSqr;
import org.openl.ie.constrainer.impl.IntBoolExpFloatEqExp;
import org.openl.ie.constrainer.impl.IntBoolExpFloatLessExp;

public abstract class FloatExpImpl
extends ExpressionImpl
implements FloatExp {
    public FloatExpImpl(Constrainer c) {
        this(c, "");
    }

    public FloatExpImpl(Constrainer c, String name) {
        super(c, name);
    }

    public FloatExp abs() {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, Math.abs(this.max()));
        }
        if (this.min() >= 0.0) {
            return this;
        }
        if (this.max() <= 0.0) {
            return this.neg();
        }
        return this.getFloatExp(FloatExpAbs.class, this);
    }

    public FloatExp add(double value) {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, this.max() + value);
        }
        return this.getFloatExp(FloatExpAddValue.class, (FloatExp)this, value);
    }

    public FloatExp add(FloatExp exp) {
        if (this.bound()) {
            return exp.add(this.max());
        }
        if (exp.bound()) {
            return this.add(exp.max());
        }
        return this.getFloatExp(FloatExpAddExp.class, (FloatExp)this, exp);
    }

    public FloatExp add(int value) {
        return this.add((double)value);
    }

    public FloatExp add(IntExp exp) {
        return this.add(exp.asFloat());
    }

    public boolean bound() {
        return FloatCalc.eq(this.min(), this.max());
    }

    public double calcCoeffs(Map map) throws NonLinearExpression {
        return this.calcCoeffs(map, 1.0);
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        throw new NonLinearExpression(this);
    }

    public FloatExp div(double value) {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, this.max() / value);
        }
        if (value == 1.0) {
            return this;
        }
        if (value == 0.0) {
            throw new IllegalArgumentException("Division by zero");
        }
        return this.mul(1.0 / value);
    }

    public FloatExp div(FloatExp exp) {
        if (this.bound()) {
            return exp.inv().mul(this.max());
        }
        return this.mul(exp.inv());
    }

    public FloatExp div(int value) {
        return this.div((double)value);
    }

    public FloatExp div(IntExp exp) {
        return this.div(exp.asFloat());
    }

    public String domainToString() {
        double max;
        double min = this.min();
        if (min == (max = this.max())) {
            return "[" + min + "]";
        }
        if (!this.bound()) {
            return "[" + min + ".." + max + "]";
        }
        return "[" + min + ".." + max + "(" + (min + max) / 2.0 + ")" + "]";
    }

    public IntBoolExp eq(double value) {
        return this.eq(this.getFloatExp(FloatExpConst.class, value));
    }

    public IntBoolExp eq(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatEqExp.class, this, exp);
    }

    public IntBoolExp eq(int value) {
        return this.eq((double)value);
    }

    public IntBoolExp eq(IntExp exp) {
        return this.eq(exp.asFloat());
    }

    public Constraint equals(double value) {
        return new ConstraintFloatExpEqualsValue(this, value);
    }

    public Constraint equals(FloatExp exp) {
        return new ConstraintFloatExpEqualsExp(this, exp);
    }

    public Constraint equals(FloatExp exp, double value) {
        return new ConstraintFloatExpEqualsExp(this, exp, value);
    }

    public Constraint equals(IntExp exp) {
        return this.equals(exp.asFloat());
    }

    public Constraint equals(IntExp exp, double value) {
        return this.equals(exp.asFloat(), value);
    }

    public FloatExp exp() {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, Math.exp(this.max()));
        }
        return this.getFloatExp(FloatExpExponent.class, this);
    }

    public FloatExp exp(double value) {
        return this.mul(Math.log(value)).exp();
    }

    public IntBoolExp ge(double value) {
        return this.ge(this.getFloatExp(FloatExpConst.class, value));
    }

    public IntBoolExp ge(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatLessExp.class, exp, this);
    }

    public IntBoolExp ge(int value) {
        return this.ge((double)value);
    }

    public IntBoolExp ge(IntExp exp) {
        return this.ge(exp.asFloat());
    }

    public IntBoolExp gt(double value) {
        return this.ge(value);
    }

    public IntBoolExp gt(FloatExp exp) {
        return this.ge(exp);
    }

    public IntBoolExp gt(int value) {
        return this.gt((double)value);
    }

    public IntBoolExp gt(IntExp exp) {
        return this.gt(exp.asFloat());
    }

    public FloatExp inv() {
        if (FloatCalc.eq(this.max(), 0.0) && FloatCalc.eq(this.min(), 0.0)) {
            throw new IllegalArgumentException("Division by zero");
        }
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, 1.0 / this.max());
        }
        return this.getFloatExp(FloatExpInverse.class, this);
    }

    public boolean isLinear() {
        return false;
    }

    public IntBoolExp le(double value) {
        return this.le(this.getFloatExp(FloatExpConst.class, value));
    }

    public IntBoolExp le(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatLessExp.class, this, exp);
    }

    public IntBoolExp le(int value) {
        return this.le((double)value);
    }

    public IntBoolExp le(IntExp exp) {
        return this.le(exp.asFloat());
    }

    public Constraint lessOrEqual(double value) {
        return new ConstraintFloatExpLessValue(this, value);
    }

    public Constraint lessOrEqual(FloatExp exp) {
        return new ConstraintFloatExpLessExp(this, exp);
    }

    public Constraint lessOrEqual(IntExp exp) {
        return this.lessOrEqual(exp.asFloat());
    }

    public FloatExp log() throws Failure {
        if (this.max() <= 0.0) {
            throw new IllegalArgumentException("log (): max() < 0");
        }
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, Math.log(this.max()));
        }
        this.setMin(0.0);
        return this.getFloatExp(FloatExpLog.class, this);
    }

    public IntBoolExp lt(double value) {
        return this.le(value);
    }

    public IntBoolExp lt(FloatExp exp) {
        return this.le(exp);
    }

    public IntBoolExp lt(int value) {
        return this.lt((double)value);
    }

    public IntBoolExp lt(IntExp exp) {
        return this.lt(exp.asFloat());
    }

    public FloatExp mod(double c) {
        throw new UnsupportedOperationException("mod");
    }

    public FloatExp mod(int c) {
        throw new UnsupportedOperationException("mod");
    }

    public Constraint moreOrEqual(double value) {
        return new ConstraintFloatExpMoreValue(this, value);
    }

    public Constraint moreOrEqual(FloatExp exp) {
        return new ConstraintFloatExpLessExp(exp, this);
    }

    public Constraint moreOrEqual(IntExp exp) {
        return this.moreOrEqual(exp.asFloat());
    }

    public FloatExp mul(double value) {
        if (value == 1.0) {
            return this;
        }
        if (value > 0.0) {
            if (this.bound()) {
                return this.getFloatExp(FloatExpConst.class, this.max() * value);
            }
            return this.getFloatExp(FloatExpMultiplyPositive.class, (FloatExp)this, value);
        }
        if (value == 0.0) {
            return this.getFloatExp(FloatExpConst.class, 0.0);
        }
        return this.neg().mul(-value);
    }

    public FloatExp mul(FloatExp exp) {
        if (exp == this) {
            return this.sqr();
        }
        if (this.bound()) {
            return exp.mul(this.max());
        }
        if (exp.bound()) {
            return this.mul(exp.max());
        }
        return this.getFloatExp(FloatExpMulExp.class, (FloatExp)this, exp);
    }

    public FloatExp mul(int value) {
        return this.mul((double)value);
    }

    public FloatExp mul(IntExp exp) {
        return this.mul(exp.asFloat());
    }

    public IntBoolExp ne(double value) {
        return this.ne(this.getFloatExp(FloatExpConst.class, value));
    }

    public IntBoolExp ne(FloatExp exp) {
        return this.getIntBoolExp(IntBoolExpFloatEqExp.class, this, exp).not();
    }

    public IntBoolExp ne(int value) {
        return this.ne((double)value);
    }

    public IntBoolExp ne(IntExp exp) {
        return this.ne(exp.asFloat());
    }

    public FloatExp neg() {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, -this.max());
        }
        return this.getFloatExp(FloatExpOpposite.class, this);
    }

    public FloatExp pow(double value) throws Failure {
        int valueI = (int)value;
        if ((double)valueI == value) {
            return this.pow(valueI);
        }
        if (this.min() < 0.0) {
            throw new IllegalArgumentException("pow (exp, value): exp < 0 for non-integer value");
        }
        if (value > 0.0) {
            if (this.bound()) {
                return this.getFloatExp(FloatExpConst.class, Math.pow(this.max(), value));
            }
            return this.getFloatExp(FloatExpPowValue.class, (FloatExp)this, value);
        }
        return this.pow(-value).inv();
    }

    public FloatExp pow(FloatExp exp) throws Failure {
        if (this.min() < 0.0) {
            throw new IllegalArgumentException("pow (exp1, exp2): exp1 < 0 for non-integer value");
        }
        if (exp.bound()) {
            return this.pow((exp.max() + exp.min()) / 2.0);
        }
        return this.log().mul(exp).exp();
    }

    public FloatExp pow(int value) throws Failure {
        switch (value) {
            case 0: {
                return this.getFloatExp(FloatExpConst.class, 1.0);
            }
            case 1: {
                return this;
            }
            case 2: {
                return this.sqr();
            }
        }
        if (value > 0) {
            if (this.bound()) {
                return this.getFloatExp(FloatExpConst.class, Math.pow(this.max(), value));
            }
            return this.getFloatExp(FloatExpPowIntValue.class, (FloatExp)this, value);
        }
        return this.pow(-value).inv();
    }

    public FloatExp pow(IntExp exp) throws Failure {
        return this.log().mul(exp.asFloat()).exp();
    }

    public void propagate() throws Failure {
    }

    public void removeRange(double min, double max) throws Failure {
        if (min < this.min()) {
            this.setMin(max);
        } else if (max > this.max()) {
            this.setMax(min);
        }
    }

    public double size() {
        return this.max() - this.min();
    }

    public FloatExp sqr() {
        if (this.bound()) {
            return this.getFloatExp(FloatExpConst.class, this.max() * this.max());
        }
        return this.getFloatExp(FloatExpSqr.class, this);
    }

    public FloatExp sub(double value) {
        return this.add(-value);
    }

    public FloatExp sub(FloatExp exp) {
        return this.add(exp.neg());
    }

    public FloatExp sub(int value) {
        return this.add((double)(-value));
    }

    public FloatExp sub(IntExp exp) {
        return this.add(exp.neg());
    }

    public String toString() {
        return this.name() + this.domainToString();
    }

    public double value() throws Failure {
        return (this.min() + this.max()) / 2.0;
    }
}

